@extends('admin.admin-layout')

@section('content')

               <!-- Start Container Fluid -->
               <div class="container-fluid">

                    <div class="row">
                         @if (session('success'))
                              <div class="alert alert-success alert-dismissible fade show " role="alert">
                                   {{ session('success') }}
                                   <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                              </div>
                         @endif
                         @if (session('error'))
                              <div class="alert alert-danger alert-dismissible fade show " role="alert">
                                   {{ session('error') }}
                                   <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                              </div>
                         @endif
                         <div class="col-xl-12">
                              <div class="card">
                                   <div class="card-header d-flex justify-content-between align-items-center gap-1">
                                        <h4 class="card-title flex-grow-1">All Product's</h4>

                                        <a href="{{route('product.Add')}}" class="btn btn-sm btn-primary">
                                             Add Product
                                        </a>
                                   </div>
                                   <div>
                                        <div class="table-responsive">
                                             <table class="table align-middle mb-0 table-hover table-centered">
                                                  <thead class="bg-light-subtle">
                                                       <tr>
                                                            <!-- <th style="width: 20px;">
                                                                 <div class="form-check ms-1">
                                                                      <input type="checkbox" class="form-check-input" id="customCheck1">
                                                                      <label class="form-check-label" for="customCheck1"></label>
                                                                 </div>
                                                            </th> -->
                                                            <th>Product Name & Size</th>
                                                            <th>Price</th>
                                                            <th>Stock</th>
                                                            <th>Category</th>
                                                            <th>Image</th>
                                                            <th>Video</th>
                                                            <th>Rating</th>
                                                            <th>Action</th>
                                                       </tr>
                                                  </thead>
                                                  <tbody>
                                                            @foreach ($products as $product)

                                                            <tr>
                                                                 <td>
                                                                      <div class="d-flex align-items-center gap-2">
                                                                           <div class="rounded bg-light avatar-md d-flex align-items-center justify-content-center">
                                                                                <img src="{{ $product->image ? asset('storage/' . $product->image) : asset('assets/images/product/no-image.png') }}" alt="" class="avatar-md rounded">
                                                                           </div>
                                                                           <div>
                                                                                <a href="{{ route('Product.Edit.id', $product->id) }}" class="link-primary fw-medium">{{ $product->name }}</a>
                                                                                <p class="text-muted mb-0 mt-1 fs-13">
                                                                                     <span>Size : </span>
                                                                                     {{ $product->size ?? 'N/A'}}
                                                                                </p>

                                                                           </div>
                                                                      </div>
                                                                 </td>

                                                                 <td>₹{{ number_format($product->price, 2) }}</td>
                                                                 <td>
                                                                      <p class="mb-1 text-muted"><span class="text-dark fw-medium">{{ $product->stock }} Item</span> Left</p>
                                                                      <p class="mb-0 text-muted">—</p> {{-- Replace with real sold data if available --}}
                                                                 </td>
                                                                 <td>
                                                                      {{ $product->category->title ?? 'N/A' }}
                                                                 </td>
                                                                 <td>
                                                                      @php
                                                                           $groupedImages = $product->images->groupBy('color.color_name');
                                                                      @endphp

                                                                      <div class="d-flex flex-column gap-2">
                                                                           @foreach($groupedImages as $colorName => $images)
                                                                                <div class="d-flex align-items-center gap-2 flex">
                                                                                     <span class="badge bg-light text-dark me-1" style="min-width: 60px; ">{{ ucfirst($colorName) }}</span>

                                                                                     @foreach($images as $img)
                                                                                          <img src="{{ asset('storage/' . $img->image_path) }}"
                                                                                               class="rounded  product-thumbnail"
                                                                                               data-bs-toggle="modal"
                                                                                               data-bs-target="#imageModal"
                                                                                               data-img="{{ asset('storage/' . $img->image_path) }}"
                                                                                               alt="Product Image">
                                                                                     @endforeach
                                                                                </div>
                                                                           @endforeach
                                                                      </div>
                                                                 </td>
                                                                 <td>
                                                                      <!-- Product Video Preview Section -->
                                                                      <div class="rounded bg-light avatar-md d-flex align-items-center justify-content-center">
                                                                           @if ($product->product_video && \Storage::disk('public')->exists($product->product_video))
                                                                                <video width="120" height="90" controls>
                                                                                     <source src="{{ asset('storage/' . $product->product_video) }}" type="video/mp4">
                                                                                     Your browser does not support the video tag.
                                                                                </video>
                                                                           @else
                                                                                <span class="text-muted">No video available</span>
                                                                           @endif
                                                                      </div>
                                                                 </td>

                                                                 <td><span class="badge p-1 bg-light text-dark fs-12 me-1"><i class="bx bxs-star align-text-top fs-14 text-warning me-1"></i> 4.5</span> 55 Review</td>
                                                                 <td>
                                                                      <div class="d-flex gap-2">
                                                                           <!-- <a href="#" class="btn btn-light btn-sm"><iconify-icon icon="solar:eye-broken" class="align-middle fs-18"></iconify-icon></a> -->
                                                                           <a href="{{ route('Product.Edit.id', $product->id) }}" class="btn btn-soft-primary btn-sm"><iconify-icon icon="solar:pen-2-broken" class="align-middle fs-18"></iconify-icon></a>
                                                                           <form action="{{ route('products.Delete', $product->id) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this product?');">
                                                                                @csrf
                                                                                @method('DELETE')
                                                                                <button type="submit" class="btn btn-soft-danger btn-sm"><iconify-icon icon="solar:trash-bin-minimalistic-2-broken" class="align-middle fs-18"></iconify-icon></button>
                                                                           </form>
                                                                      </div>
                                                                 </td>
                                                            </tr>
                                                            @endforeach
                                                       </tbody>

                                             </table>
                                        </div>
                                        <!-- end table-responsive -->
                                   </div>
                                   <div class="card-footer border-top">
                                        <div class="d-flex justify-content-end">
                                             {{ $products->links('pagination::bootstrap-5') }}
                                        </div>
                                   </div>

                              </div>
                         </div>

                    </div>

               </div>
               <!-- End Container Fluid -->
               <!-- Product Image Modal -->
               <div class="modal fade" id="imageModal" tabindex="-1" aria-labelledby="imageModalLabel" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered">
                         <div class="modal-content">
                              <div class="modal-body text-center p-0">
                              <img src="" id="modalImage" class="img-fluid rounded" alt="Preview">
                              </div>
                         </div>
                    </div>
               </div>


@endsection
<style>
    .product-thumbnail {
        width: 40px;
        height: 40px;
        object-fit: fill;
        border-radius: 4px;
        cursor: pointer;
        transition: transform 0.2s ease-in-out;
    }
    .product-thumbnail:hover {
        transform: scale(1.5);
        z-index: 10;
        position: relative;
    }
</style>
<script>
    document.addEventListener("DOMContentLoaded", function () {
        const thumbnails = document.querySelectorAll('.product-thumbnail');
        const modalImage = document.getElementById('modalImage');

        thumbnails.forEach(img => {
            img.addEventListener('click', () => {
                modalImage.src = img.dataset.img;
            });
        });
    });
</script>