@extends('admin.admin-layout')

@section('content')
<div class="container-xxl">
    <div class="row">
        @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif
        @if (session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                {{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif


        <div class="col-xl-9 col-lg-8">
            <!-- Edit Product Form -->
            <form action="{{ route('Product.Update', $product->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
               
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Edit Product Information</h4>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <!-- Product Name -->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="product-name" class="form-label">Product Name</label>
                                    <input type="text" id="product-name" name="name" class="form-control" value="{{ old('name', $product->name) }}">
                                </div>
                            </div>
                            <!-- Product Categories -->
                            <div class="col-lg-6">
                                <label for="product-categories" class="form-label">Product Categories</label>
                                <select class="form-control" name="category" id="product-categories">
                                    @foreach($categories as $category)
                                        <option value="{{ $category->id }}" {{ $product->category_id == $category->id ? 'selected' : '' }}>
                                            {{ $category->title }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="row">
                            <!-- Brand -->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label class="form-label">Brand</label>
                                    <input type="text" name="brand" class="form-control" value="{{ old('brand', $product->brand) }}">
                                </div>
                            </div>
                            <!-- Weight -->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label class="form-label">Weight</label>
                                    <input type="text" name="weight" class="form-control" value="{{ old('weight', $product->weight) }}">
                                </div>
                            </div>
                        </div>

                        <!-- Size Options -->
                        <div class="row mb-4">
                            <div class="col-lg-5">
                                <h5 class="text-dark fw-medium">Size :</h5>
                                <div class="d-flex flex-wrap gap-2">
                                    @php
                                        $selectedSizes = explode(',', $product->size);
                                    @endphp
                                    @foreach ($sizes as $size)
                                        <input type="checkbox" name="sizes[]" value="{{ $size->size }}"
                                            class="btn-check" id="size-{{ strtolower($size->size) }}"
                                            {{ in_array($size->size, $selectedSizes) ? 'checked' : '' }}>
                                        <label class="btn btn-light avatar-sm rounded d-flex justify-content-center align-items-center"
                                            for="size-{{ strtolower($size->size) }}">
                                            {{ $size->size }}
                                        </label>
                                    @endforeach
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <h5 class="text-dark fw-medium">Colors :</h5>
                                <div class="d-flex flex-wrap gap-2">
                                   @php
                                        $selectedColor = explode(',', $product->availabel_color);
                                    @endphp

                                    @foreach ($colors as $color)
                                        <input type="checkbox"
                                            name="colors[]"
                                            value="{{ $color->id }}"
                                            class="btn-check color-checkbox"
                                            id="color-{{ $color->color_name }}"
                                            data-color="{{ $color->color_name }}"
                                            {{ in_array($color->id, $selectedColor) ? 'checked' : '' }} >

                                        <label class="btn btn-light avatar-sm rounded d-flex justify-content-center align-items-center"
                                            for="color-{{ $color->color_name }}">
                                            <i class="bx bxs-circle fs-18 {{ $color->color_class }}"></i>
                                        </label>
                                    @endforeach
                                </div>
                            </div>
                        </div>

                        @php $selectedColorIds = explode(',', $product->availabel_color); @endphp
                        <!-- New Color Inputs Will Be Added Here -->
                        <div id="dynamic-color-image-inputs"></div>
                        <div class="row mt-4" id="color-image-upload-section">
                            <div class="col-lg-12">
                                <h5 class="text-dark fw-medium">Product Images by Color</h5>
                                @foreach($colors as $color)
                                    @if(in_array($color->id, $selectedColorIds))
                                        @php $colorImages = $product->images->where('color_id', $color->id); @endphp
                                        <div class="mb-4 border p-3 rounded color-image-group" data-color-id="{{ $color->id }}">
                                            <label class="form-label d-block mb-2">{{ ucfirst($color->color_name) }}</label>
                                            <div class="row mb-2">
                                                @forelse($colorImages as $img)
                                                    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 mb-3">
                                                        <div class="card">
                                                            <div class="card-body p-2">
                                                                <img src="{{ asset('storage/' . $img->image_path) }}" class="img-fluid rounded bg-light" alt="Color Image" style="height: 160px; object-fit: cover;">
                                                            </div>
                                                        </div>
                                                    </div>
                                                @empty
                                                    <div class="text-muted">No images uploaded for this color</div>
                                                @endforelse
                                            </div>
                                            <input type="file" name="color_images[{{ $color->id }}][]" multiple accept="image/*" class="form-control">
                                        </div>
                                    @endif
                                @endforeach
                            </div>
                        </div>

                        <!-- Product Image -->
                        <div class="row">
                            <div class="col-lg-5">
                                <div class="mb-3">
                                    <label for="product_image" class="form-label">Product Image</label>
                                    <input type="file" class="form-control bg-light-subtle" id="product_image" name="product_image" accept="image/*">
                                </div>
                            </div>
                            <div class="col-xl-3 col-lg-4">
                                <div class="card">
                                    <div class="card-body">
                                        <img id="preview_image" src="{{ $product->image ? asset('storage/' . $product->image) : asset('assets/images/product/p-1.png') }}" alt="Product Image Preview" class="img-fluid rounded bg-light">
                                    </div>
                                </div>
                            </div>
                        </div>
 
                        <!-- Product Video -->
                        <div class="row">
                            <div class="col-lg-5">
                                <div class="mb-3">
                                    <label for="product_video" class="form-label">Product Video</label>
                                    <input type="file" class="form-control bg-light-subtle" id="product_video" name="product_video" accept="video/mp4,video/webm,video/ogg">
                                </div>
                                @error('product_video')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-xl-6 col-lg-8">
                                <div class="card">
                                    <div class="card-body" id="videoPreviewContainer">
                                        @if ($product->product_video && \Storage::disk('public')->exists($product->product_video))
                                            <video id="preview_video" width="150px" height="230px" controls class="rounded bg-light">
                                                <source src="{{ asset('storage/' . $product->product_video) }}" type="video/mp4">
                                                Your browser does not support the video tag.
                                            </video>
                                        @else
                                            <div id="no_video_msg" class="text-muted text-center">No video available</div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>



                        <!-- Description -->
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <label for="description" class="form-label">Description</label>
                                    <textarea class="form-control" id="description" name="description" rows="5">{{ old('description', $product->description) }}</textarea>
                                </div>
                            </div>
                        </div>

                        <!-- Stock -->
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="product-stock" class="form-label">Stock</label>
                                    <input type="number" name="stock" class="form-control" value="{{ old('stock', $product->stock) }}">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Pricing -->
                <div class="card">
                    <div class="card-header"><h4 class="card-title">Pricing Details</h4></div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-5">
                                <label class="form-label">Price</label>
                                <div class="input-group mb-3">
                                    <span class="input-group-text"><i class='bx bx-dollar'></i></span>
                                    <input type="number" name="price" class="form-control" value="{{ old('price', $product->price) }}">
                                </div>
                            </div>
                            <div class="col-lg-5">
                                <label class="form-label">Discount</label>
                                <div class="input-group mb-3">
                                    <span class="input-group-text"><i class='bx bxs-discount'></i></span>
                                    <input type="number" name="discount" class="form-control" value="{{ old('discount', $product->discount) }}">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Action Buttons -->
                <div class="p-3 bg-light mb-3 rounded">
                    <div class="row justify-content-end g-2">
                        <div class="col-lg-2">
                            <button type="submit" class="btn btn-outline-secondary w-100">Update</button>
                        </div>
                        <div class="col-lg-2">
                            <a href="{{ route('product.list') }}" class="btn btn-primary w-100">Cancel</a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
 
document.getElementById('product_video').addEventListener('change', function(event) {
    const file = event.target.files[0];
    const container = document.getElementById('videoPreviewContainer');

    if (file) {
        // Clear previous preview
        container.innerHTML = '';

        // Create video element
        const video = document.createElement('video');
        video.id = 'preview_video';
        video.controls = true;
        video.className = 'img-fluid rounded bg-light';
        video.style.width = '150px';
        video.style.height = '230px';
        video.style.objectFit = 'cover';

        const source = document.createElement('source');
        source.src = URL.createObjectURL(file);
        source.type = file.type;

        video.appendChild(source);
        container.appendChild(video);
    }
});
</script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const colorCheckboxes = document.querySelectorAll('.color-checkbox');
    const container = document.getElementById('dynamic-color-image-inputs');
    const allColors = @json($colors);

    colorCheckboxes.forEach(checkbox => {
        checkbox.addEventListener('change', function () {
            const colorId = this.value;
            const colorData = allColors.find(c => c.id == colorId);
            if (this.checked) {
                if (!document.getElementById('upload-color-' + colorId)) {
                    const div = document.createElement('div');
                    div.classList.add('mb-4', 'border', 'p-3', 'rounded');
                    div.id = 'upload-color-' + colorId;
                    div.innerHTML = `
                        <label class="form-label d-block mb-2">${colorData.color_name}</label>
                        <input type="file" name="color_images[${colorId}][]" multiple accept="image/*" class="form-control">
                    `;
                    container.appendChild(div);
                }
            } else {
                const toRemove = document.getElementById('upload-color-' + colorId);
                if (toRemove) container.removeChild(toRemove);
            }
        });
    });
});
</script>
<script>
    document.getElementById('product_image').addEventListener('change', function(event) {
        const imagePreview = document.getElementById('preview_image');
        const file = event.target.files[0];

        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                imagePreview.src = e.target.result;
            };
            reader.readAsDataURL(file);
        } else {
            imagePreview.src = "assets/images/product/p-1.png"; // fallback if no file is selected
        }
    });
</script>
@endsection
