@extends('admin.admin-layout')

@section('content')
<!-- Start Container Fluid -->
<div class="container-xxl">
    <div class="row">
        @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        <div class="col-xl-9 col-lg-8">

            <!-- Product Information Form -->
            <form action="{{ route('products.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Product Information</h4>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <!-- Product Name -->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="product-name" class="form-label">Product Name</label>
                                    <input type="text" id="product-name" name="name" class="form-control" placeholder="Items Name" >
                                     <!-- <textarea id="product-name" name="name" class="form-control" placeholder="Items Name" max="200" required></textarea> -->
                                      @error('name')
                                            <div class="text-danger mt-1">{{ $message }}</div>
                                        @enderror

                                </div>
                            </div>
                            <!-- Product Categories -->
                            <div class="col-lg-6">
                                <label for="product-categories" class="form-label">Product Categories</label>
                                   <select class="form-control" id="product-categories" name="category" data-choices data-placeholder="Select Categories" >
                                        <option value=""selected disabled>Choose a category</option>
                                        @foreach($categories as $category)
                                             <option value="{{ $category['id'] }}">{{ $category['title'] }}</option>
                                        @endforeach
                                   </select>
                                   @error('category')
                                        <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror
                            </div>
                        </div>

                        <div class="row">
                            <!-- Brand -->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="product-brand" class="form-label">Brand</label>
                                    <input type="text" id="product-brand" name="brand" class="form-control" placeholder="Brand Name" >
                                    @error('brand')
                                        <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror

                                </div>
                            </div>
                            <!-- Weight -->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="product-weight" class="form-label">Weight</label>
                                    <input type="text" id="product-weight" name="weight" class="form-control" placeholder="In gm & kg" >
                                    @error('weight')
                                        <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror

                                </div>
                            </div>
                        </div>

                        <!-- Size Options -->
                        <div class="row mb-4">
                            <div class="col-lg-5">
                                <div class="mt-3">
                                    <h5 class="text-dark fw-medium">Size :</h5>
                                    <div class="d-flex flex-wrap gap-2">
                                        @foreach ($sizes as $size)
                                             <input type="checkbox" name="sizes[]" value="{{ $size->size }}" class="btn-check" id="size-{{ strtolower($size->size) }}">
                                             <label class="btn btn-light avatar-sm rounded d-flex justify-content-center align-items-center" for="size-{{ strtolower($size->size) }}">{{ $size->size }}</label>
                                        @endforeach
                                    </div>
                                    @error('sizes')
                                            <div class="text-danger mt-1">{{ $message }}</div>
                                        @enderror
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <div class="mt-3">
                                    <h5 class="text-dark fw-medium">Colors :</h5>
                                    <div class="d-flex flex-wrap gap-2">

                                        <!-- @foreach ($colors as $color)
                                            <input type="checkbox"
                                                name="colors[]"
                                                value="{{ $color->id }}"
                                                class="btn-check color-checkbox"
                                                id="color-{{ $color->color_name }}"
                                                data-color="{{ $color->color_name }}">

                                            <label class="btn btn-light avatar-sm rounded d-flex justify-content-center align-items-center"
                                                for="color-{{ $color->color_name }}">
                                                <i class="bx bxs-circle fs-18 {{ $color->color_class }}"></i>
                                            </label>
                                        @endforeach -->
                                        @foreach ($colors as $color)
                                            <div class="mb-2">
                                                <input type="checkbox"
                                                    name="colors[]"
                                                    value="{{ $color->id }}"
                                                    class="btn-check color-checkbox"
                                                    id="color-{{ $color->color_name }}"
                                                    data-color="{{ $color->color_name }}">

                                                <label class="btn btn-light avatar-sm rounded d-flex justify-content-center align-items-center"
                                                    for="color-{{ $color->color_name }}">
                                                    <i class="bx bxs-circle fs-18 {{ $color->color_class }}"></i>
                                                </label>

                                                <!-- MULTIPLE IMAGE INPUT FOR COLOR -->
                                                <div class="mt-2" id="image-input-{{ $color->id }}" style="display:none;">
                                                    <label class="form-label">Upload Images for {{ ucfirst($color->color_name) }}</label>
                                                    <input type="file" name="color_images[{{ $color->id }}][]" multiple class="form-control" accept="image/*">
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                    @error('colors')
                                            <div class="text-danger mt-1">{{ $message }}</div>
                                        @enderror
                                </div>
                            </div>

                        </div>

                        <!-- Product Image -->
                        <div class="row">
                            <div class="col-lg-5">
                                <div class="mb-3">
                                    <label for="product_image" class="form-label">Product Thumbnail</label>
                                    <input type="file" class="form-control bg-light-subtle" id="product_image" name="product_image" accept="image/*">
                                </div>
                                        @error('product_image')
                                            <div class="text-danger mt-1">{{ $message }}</div>
                                        @enderror
                            </div>
                            <div class="col-xl-3 col-lg-4">
                                <div class="card">
                                    <div class="card-body">
                                        <img id="preview_image" src="assets/images/product/p-1.png" alt="Product Image Preview" class="img-fluid rounded bg-light">
                                    </div>
                                </div>
                            </div>
                        </div>


                        <!-- Product Video Upload -->
                        <div class="row">
                            <div class="col-lg-5">
                                <div class="mb-3">
                                    <label for="product_video" class="form-label">Product Video</label>
                                    <input type="file" class="form-control bg-light-subtle" id="product_video" name="product_video" accept="video/mp4,video/webm,video/ogg">
                                </div>
                                @error('product_video')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-xl-3 col-lg-4">
                                <div class="card">
                                    <div class="card-body">
                                        <video id="preview_video" controls class="img-fluid rounded bg-light" style="width: 100%; max-height: 240px;">
                                            <source src="" type="video/mp4">
                                            Your browser does not support the video tag.
                                        </video>
                                    </div>
                                </div>
                            </div>
                        </div>




                        <!-- Description -->
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <label for="description" class="form-label">Description</label>
                                    <textarea class="form-control bg-light-subtle" id="description" name="description" rows="5" max="500" placeholder="Short description about the product"></textarea>
                                    @error('description')
                                        <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror

                                </div>
                            </div>
                        </div>

                        <!-- Tag, Stock, Tags -->
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="product-stock" class="form-label">Stock</label>
                                    <input type="number" id="product-stock" name="stock" class="form-control" placeholder="Quantity" > 
                                    @error('stock')
                                        <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Pricing -->
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Pricing Details</h4>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-5">
                                <label for="product-price" class="form-label">Price</label>
                                <div class="input-group mb-3">
                                    <span class="input-group-text fs-20"><i class='bx bx-dollar'></i></span>
                                    <input type="number" id="product-price" name="price" class="form-control" placeholder="000" >
                                </div>
                                 @error('price')
                                        <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror
                            </div>
                            <div class="col-lg-5">
                                <label for="product-discount" class="form-label">Discount</label>
                                <div class="input-group mb-3">
                                    <span class="input-group-text fs-20"><i class='bx bxs-discount'></i></span>
                                    <input type="number" id="product-discount" name="discount" class="form-control" placeholder="000" >
                                    @error('discount')
                                        <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Action Buttons -->
                <div class="p-3 bg-light mb-3 rounded">
                    <div class="row justify-content-end g-2">
                        <div class="col-lg-2">
                            <button type="submit" class="btn btn-outline-secondary w-100">Add Product</button>
                        </div>
                        <div class="col-lg-2">
                            <a href="#" class="btn btn-primary w-100">Cancel</a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- End Container Fluid -->
<script>
//  script for Image preview    
    document.getElementById('product_image').addEventListener('change', function(event) {
        const imagePreview = document.getElementById('preview_image');
        const file = event.target.files[0];

        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                imagePreview.src = e.target.result;
            };
            reader.readAsDataURL(file);
        } else {
            imagePreview.src = "assets/images/product/p-1.png"; // fallback if no file is selected
        }
    });
//  script for video preview
    document.getElementById('product_video').addEventListener('change', function(event) {
        const file = event.target.files[0];
        if (file) {
            const videoURL = URL.createObjectURL(file);
            const video = document.getElementById('preview_video');
            video.src = videoURL;
            video.load();
            video.play();
        }
    });

</script>
<script>
    document.querySelectorAll('.color-checkbox').forEach(checkbox => {
        checkbox.addEventListener('change', function () {
            const colorId = this.value;
            const imageInput = document.getElementById(`image-input-${colorId}`);
            if (this.checked) {
                imageInput.style.display = 'block';
            } else {
                imageInput.style.display = 'none';
            }
        });
    });
</script>

@endsection
