@extends('admin.admin-layout')

@section('content')

               <!-- Start Container -->
               <div class="container-xxl">

                    <div class="row">
                         <div class="col-xl-9 col-lg-8">
                              <div class="row">
                                   <div class="col-lg-12">
                                        <div class="card">
                                             <div class="card-body">
                                                  <div class="d-flex flex-wrap align-items-center justify-content-between gap-2">
                                                       <div>
                                                            <h4 class="fw-medium text-dark d-flex align-items-center gap-2">
                                                            #{{ $order->id }} 
                                                            <span class="badge bg-{{ $order->payment_status === 'paid' ? 'success' : 'light' }}-subtle text-{{ $order->payment_status === 'paid' ? 'success' : 'dark' }} px-2 py-1 fs-13">
                                                                 {{ ucfirst($order->payment_status) }}
                                                            </span>
                                                           @switch($order->shipping_status)
                                                            @case('Pending')
                                                                 <span class="badge border border-warning text-warning px-2 py-1 fs-13 rounded">Pending</span>
                                                                 @break
                                                            @case('Processing')
                                                                 <span class="badge border border-purple text-purple px-2 py-1 fs-13 rounded">Processing</span>
                                                                 @break
                                                            @case('Delivered')
                                                                 <span class="badge border border-success text-success px-2 py-1 fs-13 rounded">Delivered</span>
                                                                 @break
                                                            @case('Dispatched')
                                                                 <span class="badge border border-info text-info px-2 py-1 fs-13 rounded">Dispatched</span>
                                                                 @break
                                                            @case('Return')
                                                                 <span class="badge border border-danger text-danger px-2 py-1 fs-13 rounded">Return</span>
                                                                 @break
                                                            @default
                                                                 <span class="badge border border-secondary text-secondary px-2 py-1 fs-13 rounded">Unknown</span>
                                                            @endswitch

                                                            </h4>
                                                            <p class="mb-0">Order / Order Details / #{{ $order->id }} - {{ $order->created_at->format('F d, Y \a\t h:i A') }}</p>

                                                       </div>
                                                       <div>
                                                            <a href="#updatestatusoforder" class="btn btn-primary"
                                                                 data-bs-toggle="modal"
                                                                 data-order-id="{{ $order->id }}"
                                                                 data-order-status="{{ $order->shipping_status }}"
                                                            >Update Order Status</a>
                                                       </div>

                                                  </div>
                                             </div>
                                        </div>
                                        <div class="card">
                                             <div class="card-header">
                                                  <h4 class="card-title">Product</h4>
                                             </div>
                                             <div class="card-body">
                                                  <div class="table-responsive">
                                                       <table class="table align-middle mb-0 table-hover table-centered">
                                                            <thead class="bg-light-subtle border-bottom">
                                                                 <tr>
                                                                      <th>Product Name & Size</th>
                                                                      <th>Status</th>
                                                                      <th>Quantity</th>
                                                                      <th>Price</th>
                                                                      <th>Tax</th>
                                                                      <th>Amount</th>
                                                                 </tr>
                                                            </thead>
                                                            <tbody>
                                                                 @foreach($order->items as $item)
                                                                 <tr>
                                                                      <td>
                                                                           <div class="d-flex align-items-center gap-2">
                                                                                <div class="rounded  avatar-md d-flex align-items-center justify-content-center">
                                                                                     <img src="{{ asset('storage/' . $item->product->image) }}" alt="" class="avatar-md">
                                                                                </div>
                                                                                <div>
                                                                                     <a href="#!" class="text-dark fw-medium fs-15">{{ $item->product->name ?? 'Product' }}</a>
                                                                                     <p class="text-muted mb-0 mt-1 fs-13"><span>Size : </span>{{ $item->product_size }}</p>
                                                                                </div>
                                                                           </div>
                                                                      </td>
                                                                      <td>
                                                                           <span class="badge bg-success-subtle text-success px-2 py-1 fs-13">Ready</span>
                                                                      </td>
                                                                      <td>{{ $item->quantity }}</td>
                                                                      <td>₹ {{ number_format($item->order_price, 2) }}</td>
                                                                      <td>₹ 0.00</td> {{-- Tax or additional charges --}}
                                                                      <td>₹ {{ number_format($item->quantity * $item->order_price, 2) }}</td>
                                                                 </tr>
                                                                 @endforeach
                                                                 </tbody>

                                                       </table>
                                                  </div>
                                             </div>
                                        </div>
                                        <div class="card">
                                             <div class="card-header">
                                                  <h4 class="card-title">Customer Details</h4>
                                             </div>
                                             <div class="card-body">
                                                  <div class="d-flex align-items-center gap-2">
                                                                                                   <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><circle cx="12" cy="6" r="4" fill="currentColor"/><path fill="currentColor" d="M20 17.5c0 2.485 0 4.5-8 4.5s-8-2.015-8-4.5S7.582 13 12 13s8 2.015 8 4.5"/></svg>
                                                       <div>
                                                            <p class="mb-1">{{ $order->first_name . ' ' . $order->last_name }}</p>
                                                            <!-- <a href="#!" class="link-primary fw-medium">hello@dundermuffilin.com</a> -->
                                                       </div>
                                                  </div>
                                                  <div class="d-flex justify-content-between mt-3">
                                                       <h5 class="">Contact Number</h5>
                                                       <div>
                                                            <!-- <a href="#!"><i class='bx bx-edit-alt fs-18'></i></a> -->
                                                       </div>
                                                  </div>
                                                  <p class="mb-1">{{ $order->phone }}</p>

                                                  <div class="d-flex justify-content-between mt-3">
                                                       <h5 class="">Shipping Address</h5>
                                                       <div>
                                                            <!-- <a href="#!"><i class='bx bx-edit-alt fs-18'></i></a> -->
                                                       </div>
                                                  </div>

                                                  <div>
                                                       <p class="mb-1">{{ $order->address }}</p>
                                                       <p class="mb-1">{{ $order->apartment }}</p>
                                                       <p class="mb-1">{{ $order->city }}, {{ $order->state }}</p>
                                                       <p class="mb-1">{{ $order->pincode }}</p>
                                                  </div>

                                                  <div class="d-flex justify-content-between mt-3">
                                                       <h5 class="">Billing Address</h5>
                                                       <div>
                                                            <!-- <a href="#!"><i class='bx bx-edit-alt fs-18'></i></a> -->
                                                       </div>
                                                  </div>

                                                  <p class="mb-1">Same as shipping address</p>
                                             </div>
                                        </div>
                                   </div>
                              </div>
                         </div>
                         <div class="col-xl-3 col-lg-4">
                              <div class="card">
                                   <div class="card-header">
                                        <h4 class="card-title">Order Summary</h4>
                                   </div>
                                   <div class="card-body">
                                        <div class="table-responsive">
                                             <table class="table mb-0">
                                                  <tbody>
                                                       <tr>
                                                            <td class="px-0">
                                                                 <p class="d-flex mb-0 align-items-center gap-1">Sub Total : </p>
                                                            </td>
                                                            <td class="text-end text-dark fw-medium px-0">₹ {{ number_format($order->subtotal, 2) }}</td>
                                                       </tr>
                                                       <tr>
                                                            <td class="px-0">
                                                                 <p class="d-flex mb-0 align-items-center gap-1">Discount : </p>
                                                            </td>
                                                            <td class="text-end text-dark fw-medium px-0">
                                                                 - ₹ {{ number_format(($order->coupon_applied ? ($order->subtotal - $order->total + $order->shipping_cost) : 0), 2) }}
                                                            </td>
                                                       </tr>
                                                       <tr>
                                                            <td class="px-0">Delivery Charge:</td>
                                                            <td class="text-end text-dark fw-medium px-0">₹ {{ number_format($order->shipping_cost, 2) }}</td>
                                                       </tr>
                                                       <tr>
                                                            <td class="px-0">Estimated Tax (0%) :</td>
                                                            <td class="text-end text-dark fw-medium px-0">₹ 0.00</td>
                                                       </tr>


                                                  </tbody>
                                             </table>
                                        </div>
                                   </div>
                                   <div class="card-footer d-flex align-items-center justify-content-between bg-light-subtle">
                                        <div>
                                             <p class="fw-medium text-dark mb-0">Total Amount</p>
                                        </div>
                                        <div>
                                             <p class="fw-medium text-dark mb-0">₹ {{ number_format($order->total, 2) }}</p>
                                        </div>

                                   </div>
                              </div>
                              <div class="card">
                                   <div class="card-header">
                                        <h4 class="card-title">Payment Information</h4>
                                   </div>
                                   <div class="card-body">
                                        <div class="d-flex align-items-center gap-3 mb-3">
                                            <p class="text-dark mb-1 fw-medium">Transaction ID: <br><span class="text-muted fw-normal fs-13">#{{ $order->razorpay_payment_id ?? 'N/A' }}</span></p>
                                             <div class="ms-auto">
                                                  <iconify-icon icon="solar:check-circle-broken" class="fs-18 text-success"></iconify-icon>
                                             </div>
                                        </div>
                                        <p class="text-dark mb-0 fw-medium">Card Holder Name: <br> <span class="text-muted fw-normal fs-13">{{ $order->first_name . ' ' . $order->last_name }}</span></p>
                                   </div>
                              </div>
                         </div>
                    </div>
               </div>

          </div>
          <!-- End Container Fluid -->


          <!-- Button trigger modal -->
<a class="btn btn-primary" data-bs-toggle="modal" href="#exampleModalToggle" role="button">Open first modal</a>

<!-- First Modal -->
<div class="modal fade" id="exampleModalToggle" aria-hidden="true" aria-labelledby="exampleModalToggleLabel" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalToggleLabel">Modal 1</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                Show a second modal and hide this one with the button below.
            </div>
            <div class="modal-footer">
                <button class="btn btn-primary" data-bs-target="#exampleModalToggle2" data-bs-toggle="modal">Open
                    second modal</button>
            </div>
        </div>
    </div>
</div>


<!-- Second Modal -->
<div class="modal fade" id="updatestatusoforder" aria-hidden="true" aria-labelledby="exampleModalToggleLabel" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form action="{{ route('admin.orders.updateStatus') }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalToggleLabel">Update Order Status</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="order_id" id="modal_order_id" value="">
                    <label for="order_status" class="form-label">Select Status</label>
                    <select name="order_status" id="modal_order_status" class="form-select" required>
                        <option value="">-- Choose Status --</option>
                        <option value="Pending" {{ $order->shipping_status == 'Pending' ? 'selected' : '' }}>Pending</option>
                        <option value="Processing" {{ $order->shipping_status == 'Processing' ? 'selected' : '' }}>Processing</option>
                        <option value="Dispatched" {{ $order->shipping_status == 'Dispatched' ? 'selected' : '' }}>Dispatched</option>
                        <option value="Delivered" {{ $order->shipping_status == 'Delivered' ? 'selected' : '' }}>Delivered</option>
                        <option value="Return" {{ $order->shipping_status == 'Return' ? 'selected' : '' }}>Return</option>
                    </select>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Update Status</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </form>
        </div>
    </div>
</div>


<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    const statusModal = document.getElementById('updatestatusoforder');
    statusModal.addEventListener('show.bs.modal', function (event) {
        const button = event.relatedTarget;
        const orderId = button.getAttribute('data-order-id');
        const orderStatus = button.getAttribute('data-order-status');

        const inputOrderId = statusModal.querySelector('#modal_order_id');
        const selectStatus = statusModal.querySelector('#modal_order_status');

        // Set the order ID
        inputOrderId.value = orderId;

        // Set the selected status
        if (orderStatus) {
            selectStatus.value = orderStatus;
        } else {
            selectStatus.selectedIndex = 0; // default
        }
    });
</script>
@endsection
