@extends('admin.admin-layout')

@section('content')


<!-- Start Container Fluid -->
               <div class="container-fluid">

                    <!-- Start here.... -->
                    <div class="row mt-3">
                         <div class="col-xxl-5">
                              <div class="row">
                                  <div class="col-md-4">
                                        <a href="{{route('admin.orders.list')}}" class="card-link">
                                             <div class="card overflow-hidden hover-card">
                                                  <div class="card-body">
                                                       <div class="row">
                                                            <div class="col-6">
                                                                 <div class="avatar-md bg-soft-primary rounded">
                                                                      <iconify-icon icon="solar:cart-5-bold-duotone" class="avatar-title fs-32 text-primary"></iconify-icon>
                                                                 </div>
                                                            </div>
                                                            <div class="col-6 text-end">
                                                                 <p class="text-muted mb-0 text-truncate">Total Order's</p>
                                                                 <h3 class="text-dark mt-1 mb-0">
                                                                      <span class="text-success"><i class="bx bxs-up-arrow fs-12"></i></span> 
                                                                      {{ $totalorders }}
                                                                 </h3>
                                                            </div>
                                                       </div>
                                                  </div>
                                             </div>
                                        </a>
                                   </div>

                                   <div class="col-md-4">
                                        <a href="{{route('product.list')}}" class="card-link">
                                             <div class="card overflow-hidden hover-card">
                                                  <div class="card-body">
                                                       <div class="row">
                                                            <div class="col-6">
                                                                 <div class="avatar-md bg-soft-primary rounded">
                                                                      <i class="bx bx-award avatar-title fs-24 text-primary"></i>
                                                                 </div>
                                                            </div>
                                                            <div class="col-6 text-end">
                                                                 <p class="text-muted mb-0 text-truncate">Total Product's</p>
                                                                 <h3 class="text-dark mt-1 mb-0">
                                                                      <span class="text-success"><i class="bx bxs-up-arrow fs-12"></i></span>
                                                                      {{ $totalProducts }}
                                                                 </h3>
                                                            </div>
                                                       </div>
                                                  </div>
                                             </div>
                                        </a>
                                   </div>

                                   <div class="col-md-4">
                                        <a href="{{route('Category.list')}}" class="card-link">
                                             <div class="card overflow-hidden hover-card">
                                                  <div class="card-body">
                                                       <div class="row">
                                                            <div class="col-6">
                                                                 <div class="avatar-md bg-soft-primary rounded">
                                                                      <i class="bx bx-award avatar-title fs-24 text-primary"></i>
                                                                 </div>
                                                            </div>
                                                            <div class="col-6 text-end">
                                                                 <p class="text-muted mb-0 text-truncate">Total Category's</p>
                                                                 <h3 class="text-dark mt-1 mb-0">
                                                                      <span class="text-success"><i class="bx bxs-up-arrow fs-12"></i></span>
                                                                      {{ $totalCategorys }}
                                                                 </h3>
                                                            </div>
                                                       </div>
                                                  </div>
                                             </div>
                                        </a>
                                   </div>

                                   <div class="col-md-4">
                                        <a href="{{route('all.users')}}" class="card-link">
                                             <div class="card overflow-hidden hover-card">
                                                  <div class="card-body">
                                                       <div class="row">
                                                            <div class="col-6">
                                                                 <div class="avatar-md bg-soft-primary rounded">
                                                                      <i class="bx bxs-backpack avatar-title fs-24 text-primary"></i>
                                                                 </div>
                                                            </div>
                                                            <div class="col-6 text-end">
                                                                 <p class="text-muted mb-0 text-truncate">User's</p>
                                                                 <h3 class="text-dark mt-1 mb-0">
                                                                      <span class="text-success"><i class="bx bxs-up-arrow fs-12"></i></span>
                                                                      {{ $totalUsers }}
                                                                 </h3>
                                                            </div>
                                                       </div>
                                                  </div>
                                             </div>
                                        </a>
                                   </div>

                                   <div class="col-md-4">
                                        <a href="{{route('All-coupons')}}" class="card-link">
                                             <div class="card overflow-hidden hover-card">
                                                  <div class="card-body">
                                                       <div class="row">
                                                            <div class="col-6">
                                                                 <div class="avatar-md bg-soft-primary rounded">
                                                                      <i class="bx bx-dollar-circle avatar-title text-primary fs-24"></i>
                                                                 </div>
                                                            </div>
                                                            <div class="col-6 text-end">
                                                                 <p class="text-muted mb-0 text-truncate">Total Coupon's</p>
                                                                 <h3 class="text-dark mt-1 mb-0">
                                                                      <span class="text-success"><i class="bx bxs-up-arrow fs-12"></i></span>
                                                                      {{ $totalCoupons }}
                                                                 </h3>
                                                            </div>
                                                       </div>
                                                  </div>
                                             </div>
                                        </a>
                                   </div>

                              </div> <!-- end row -->
                         </div> <!-- end col -->
                    </div> <!-- end row -->


                    <div class="row">
                         <div class="col">
                              <div class="card">
                                   <div class="card-body">
                                        <div class="d-flex align-items-center justify-content-between">
                                             <h4 class="card-title">
                                                  Recent Orders
                                             </h4>

                                        </div>
                                   </div>
                                   <!-- end card body -->
                                   <div class="table-responsive table-centered">
                                        <table class="table mb-0">
                                             <thead class="bg-light bg-opacity-50">
                                                  <tr>
                                                       <!-- <th>Order ID</th> -->
                                                       <th>Created at</th>
                                                       <th>Customer</th>
                                                       <th>Phone</th>
                                                       <th>Total</th>
                                                       <th>Payment Status</th>
                                                       <th>Items</th>
                                                       <th>Delivery Address</th>
                                                       <th>Order Status</th>
                                                       <th>Action</th>
                                                  </tr>
                                             </thead>
                                             <!-- end thead-->
                                             <tbody>
                                                       @forelse ($orders as $order)
                                                       <tr>
                                                            <!-- <td>#{{ $order->id ?? 'N/A' }}</td> -->

                                                            <td>{{ $order->created_at?->format('M d, Y') ?? 'N/A' }}</td>

                                                           <td>
                                                                 <div class="d-flex justify-content-between align-items-center">
                                                                      <a href="{{ route('admin.orders.show', $order->id) }}" class="link-primary fw-medium">
                                                                           {{ ($order->first_name || $order->last_name) ? $order->first_name . ' ' . $order->last_name : 'Guest' }}
                                                                      </a>
                                                                      <a href="#updatestatusoforder"
                                                                           class="btn btn-soft-primary btn-sm ms-2"
                                                                           data-bs-toggle="modal"
                                                                           data-order-id="{{ $order->id }}"
                                                                           data-order-status="{{ $order->shipping_status }}"
                                                                      >
                                                                           <iconify-icon icon="solar:pen-2-broken" class="align-middle fs-18"></iconify-icon>
                                                                      </a>
                                                                 </div>
                                                            </td>


                                                            <td>{{ $order->phone ?? 'N/A' }}</td>

                                                            <td>₹ {{number_format($order->subtotal ?? 0, 2) }}</td>

                                                            <td>
                                                                 @if ($order->payment_status === 'paid')
                                                                      <span class="badge bg-success text-light px-2 py-1 fs-13">Paid</span>
                                                                 @elseif ($order->payment_status === 'refund')
                                                                      <span class="badge bg-light text-dark px-2 py-1 fs-13">Refund</span>
                                                                 @else
                                                                      <span class="badge bg-light text-dark px-2 py-1 fs-13">Unpaid</span>
                                                                 @endif
                                                            </td>

                                                            <td>
                                                                 {{-- Sum of all quantities in order items --}}
                                                                 {{ $order->items->sum('quantity') ?? 0 }}
                                                            </td>

                                                            <td>
                                                                 {{ $order->address.','.$order->apartment.','.$order->city.','.$order->state  }}
                                                            </td>

                                                            <td>
                                                                 @switch($order->shipping_status)
                                                                      @case('Pending')
                                                                           <span class="badge border border-warning text-warning px-2 py-1 fs-13">Pending</span>
                                                                           @break
                                                                      @case('Processing')
                                                                           <span class="badge border border-purple text-purple px-2 py-1 fs-13">Processing</span>
                                                                           @break
                                                                      @case('Delivered')
                                                                           <span class="badge border border-success text-success px-2 py-1 fs-13">Delivered</span>
                                                                           @break
                                                                      @case('Dispatched')
                                                                           <span class="badge border border-info text-info px-2 py-1 fs-13">Dispatched</span>
                                                                           @break
                                                                      @case('Return')
                                                                           <span class="badge border border-danger text-danger px-2 py-1 fs-13">Return</span>
                                                                           @break
                                                                      @default
                                                                           <span class="badge border border-secondary text-secondary px-2 py-1 fs-13">Unknown</span>
                                                                 @endswitch
                                                            </td>

                                                            <td>
                                                                 <div class="d-flex gap-2">
                                                                      <a href="{{ route('admin.orders.show', $order->id) }}" class="btn btn-light btn-sm">
                                                                           <iconify-icon icon="solar:eye-broken" class="align-middle fs-18"></iconify-icon>
                                                                      </a>

                                                                      <a href="#updatestatusoforder"
                                                                           class="btn btn-soft-primary btn-sm"
                                                                           data-bs-toggle="modal"
                                                                           data-order-id="{{ $order->id }}"
                                                                           data-order-status="{{ $order->shipping_status }}"
                                                                      >
                                                                      <iconify-icon icon="solar:pen-2-broken" class="align-middle fs-18"></iconify-icon>
                                                                      </a>

                                                                      <form action="{{ route('admin.orders.destroy', $order->id) }}" method="POST" class="delete-order-form">
                                                                           @csrf
                                                                           @method('DELETE')
                                                                           <button type="button" class="btn btn-soft-danger btn-sm sweetalert-delete-btn">
                                                                                <iconify-icon icon="solar:trash-bin-minimalistic-2-broken" class="align-middle fs-18"></iconify-icon>
                                                                           </button>
                                                                      </form>

                                                                 </div>
                                                            </td>
                                                       </tr>
                                                       @empty
                                                       <tr>
                                                            <td colspan="11" class="text-center">No orders found.</td>
                                                       </tr>
                                                       @endforelse
                                             </tbody>
                                             <!-- end tbody -->
                                        </table>
                                        <!-- end table -->
                                   </div>
                                   <!-- table responsive -->

                                   <div class="card-footer border-top">
                                        <div class="row g-3">
                                             <div class="col-sm">
                                                  <div class="text-muted">
                                                       Showing
                                                       <span class="fw-semibold">5</span>
                                                       of
                                                       <span class="fw-semibold">90,521</span>
                                                       orders
                                                  </div>
                                             </div>

                                             <div class="col-sm-auto">
                                                  <ul class="pagination m-0">
                                                       <li class="page-item">
                                                            <a href="#" class="page-link"><i class="bx bx-left-arrow-alt"></i></a>
                                                       </li>
                                                       <li class="page-item active">
                                                            <a href="#" class="page-link">1</a>
                                                       </li>
                                                       <li class="page-item">
                                                            <a href="#" class="page-link">2</a>
                                                       </li>
                                                       <li class="page-item">
                                                            <a href="#" class="page-link">3</a>
                                                       </li>
                                                       <li class="page-item">
                                                            <a href="#" class="page-link"><i class="bx bx-right-arrow-alt"></i></a>
                                                       </li>
                                                  </ul>
                                             </div>
                                        </div>
                                   </div>
                              </div>
                              <!-- end card -->
                         </div>
                         <!-- end col -->
                    </div> <!-- end row -->

               </div>
               <!-- End Container Fluid -->
                <!-- Second Modal -->
<div class="modal fade" id="updatestatusoforder" aria-hidden="true" aria-labelledby="exampleModalToggleLabel" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form action="{{ route('admin.orders.updateStatus') }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalToggleLabel">Update Order Status</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="order_id" id="modal_order_id" value="">
                    <label for="order_status" class="form-label">Select Status</label>
                    <select name="order_status" id="modal_order_status" class="form-select" required>
                        <option value="">-- Choose Status --</option>
                        <option value="Pending" {{ $order->shipping_status == 'Pending' ? 'selected' : '' }}>Pending</option>
                        <option value="Processing" {{ $order->shipping_status == 'Processing' ? 'selected' : '' }}>Processing</option>
                        <option value="Dispatched" {{ $order->shipping_status == 'Dispatched' ? 'selected' : '' }}>Dispatched</option>
                        <option value="Delivered" {{ $order->shipping_status == 'Delivered' ? 'selected' : '' }}>Delivered</option>
                        <option value="Return" {{ $order->shipping_status == 'Return' ? 'selected' : '' }}>Return</option>
                    </select>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Update Status</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </form>
        </div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    const statusModal = document.getElementById('updatestatusoforder');
    statusModal.addEventListener('show.bs.modal', function (event) {
        const button = event.relatedTarget;
        const orderId = button.getAttribute('data-order-id');
        const orderStatus = button.getAttribute('data-order-status');

        const inputOrderId = statusModal.querySelector('#modal_order_id');
        const selectStatus = statusModal.querySelector('#modal_order_status');

        // Set the order ID
        inputOrderId.value = orderId;

        // Set the selected status
        if (orderStatus) {
            selectStatus.value = orderStatus;
        } else {
            selectStatus.selectedIndex = 0; // default
        }
    });
</script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const deleteButtons = document.querySelectorAll('.sweetalert-delete-btn');

    deleteButtons.forEach(button => {
        button.addEventListener('click', function (e) {
            const form = this.closest('form');

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, delete it!',
                cancelButtonText: 'No, cancel!',
                customClass: {
                    confirmButton: 'btn btn-primary w-xs me-2 mt-2',
                    cancelButton: 'btn btn-danger w-xs mt-2'
                },
                buttonsStyling: false
            }).then((result) => {
                if (result.isConfirmed) {
                    form.submit(); // Submit the form if confirmed
                } else if (result.dismiss === Swal.DismissReason.cancel) {
                    Swal.fire({
                        title: 'Cancelled',
                        text: 'Your order is safe :)',
                        icon: 'error',
                        confirmButtonText: 'OK',
                        customClass: {
                            confirmButton: 'btn btn-primary mt-2'
                        },
                        buttonsStyling: false
                    });
                }
            });
        });
    });
});
</script>
@endsection
<style>
     .card-link {
  text-decoration: none;
  color: inherit;
}

.hover-card {
  transition: transform 0.3s ease, box-shadow 0.3s ease;
  cursor: pointer;
}

.hover-card:hover {
  transform: translateY(-5px);
  box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
}

</style>       