@extends('admin.admin-layout')

@section('content')

<!-- Start Container Fluid -->
<div class="container-xxl">
       @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif
    <div class="row">
        <div class="col-xl-12">
            <div class="card">
                <div class="d-flex card-header justify-content-between align-items-center">
                    <div>
                        <h4 class="card-title">All Coupon's </h4>
                    </div>
                    <div class="col-lg-6">   
                         <div class="text-md-end mt-3 mt-md-0 d-flex justify-content-end align-items-center gap-1">
                              <form class="app-search d-none d-md-block " method="GET" action="#">
                                   <div class="position-relative">
                                        <input type="search" class="form-control" placeholder="Search Coupons and Code" autocomplete="off" name="search" value="">
                                        <iconify-icon icon="solar:magnifer-broken" class="search-widget-icon position-absolute top-50 end-0 translate-middle-y me-2"></iconify-icon>
                                   </div>
                              </form>

                              <a href="{{ route('Add-coupon') }}" class="btn btn-success">
                                   <i class="bx bx-plus"></i> New Coupons
                              </a>
                         </div>
                    </div>
                </div>
                <div>
                    <div class="table-responsive">
                        <table class="table align-middle mb-0 table-hover table-centered">
                            <thead class="bg-light-subtle">
                                <tr>
                                    <th>Coupon Code</th>
                                    <th>Type</th>
                                    <th>Value</th>
                                    <th>Start Date</th>
                                    <th>End Date</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($coupons as $coupon)
                                    <tr>
                                        <td>
                                            <a href="{{ route('Edit-coupon', $coupon->id) }}" class="link-primary fw-medium ">{{ $coupon->code }}</a>
                                        </td>
                                        <td class="text-capitalize">{{ $coupon->type }}</td>
                                        <td>
                                            @if($coupon->type == 'percent')
                                                {{ $coupon->value }}%
                                            @else
                                                ₹{{ $coupon->value }}
                                            @endif
                                        </td>
                                        <td>{{ \Carbon\Carbon::parse($coupon->start_date)->format('d M Y') }}</td>
                                        <td>{{ \Carbon\Carbon::parse($coupon->end_date)->format('d M Y') }}</td>
                                        <td>
                                            @php
                                                $badgeClass = match($coupon->status) {
                                                    'active' => 'text-success bg-success-subtle',
                                                    'inactive' => 'text-danger bg-danger-subtle',
                                                    'future' => 'text-warning bg-warning-subtle',
                                                    default => 'text-secondary bg-secondary-subtle',
                                                };
                                            @endphp
                                            <span class="badge {{ $badgeClass }} fs-12 text-capitalize">
                                                <i class="bx bx-check-double"></i> {{ $coupon->status }}
                                            </span>
                                        </td>
                                        <td>
                                            <div class="d-flex gap-2">
                                                <a href="{{ route('Edit-coupon', $coupon->id) }}" class="btn btn-soft-primary btn-sm">
                                                    <iconify-icon icon="solar:pen-2-broken" class="align-middle fs-18"></iconify-icon>
                                                </a>
                                                <form action="{{ route('Delete-coupon', $coupon->id) }}" method="POST" onsubmit="return confirm('Are you sure?')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button class="btn btn-soft-danger btn-sm" type="submit">
                                                        <iconify-icon icon="solar:trash-bin-minimalistic-2-broken" class="align-middle fs-18"></iconify-icon>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                                @if($coupons->isEmpty())
                                    <tr>
                                        <td colspan="7" class="text-center">No coupons found.</td>
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                    <!-- end table-responsive -->
                </div>
                <div class="card-footer border-top">
                    {{ $coupons->links('pagination::bootstrap-5') }}
                </div>
            </div>
        </div>
    </div>
</div>
<!-- End Container Fluid -->

@endsection
