@extends('admin.admin-layout')

@section('content')

<!-- Start Container Fluid -->
<div class="container-xxl">
    <div class="row">
        @if(session('success'))
            <div class="alert alert-success" role="alert">
                {{ session('success') }}
            </div>
        @endif

        <div class="col-xl-9 col-lg-8">
            <form action="{{route('category.store')}}" method="post" enctype="multipart/form-data">
                @csrf
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Create Category</h4>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="category-title" class="form-label">Category Title</label>
                                    <input type="text" id="category-title" name="category_title" class="form-control" placeholder="Enter Title" require>
                                     @error('category_title')
                                            <div class="text-danger mt-1">{{ $message }}</div>
                                        @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-lg-6">
                                <div class="mb-1">
                                    <label for="categoryimage" class="form-label">Category Image</label>
                                    <input type="file" name="categoryimage" id="categoryimage" class="form-control" require>
                                     @error('categoryimage')
                                            <div class="text-danger mt-1">{{ $message }}</div>
                                        @enderror
                                </div>
                            </div>
                            <div class="col-xl-3 col-lg-4">
                                        <div id="preview-container" class="bg-light text-center rounded bg-light" style="display: none;">
                                            <img id="preview-image" src="#" alt="Preview Image" class="img-fluid rounded bg-light">
                                        </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-lg-12">
                                <div class="mb-0">
                                    <label for="description" class="form-label">Description</label>
                                    <textarea class="form-control bg-light-subtle" id="description" name="description" rows="7" placeholder="Type description" require></textarea>
                                     @error('description')
                                            <div class="text-danger mt-1">{{ $message }}</div>
                                        @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="p-3 bg-light mb-3 rounded">
                    <div class="row justify-content-end g-2">
                        <div class="col-lg-3">
                            <button type="submit" class="btn btn-outline-secondary w-100">Create Category</button>
                        </div>
                        <div class="col-lg-2">
                            <a href="#!" class="btn btn-primary w-100">Cancel</a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- End Container Fluid -->


<script>
    document.getElementById('categoryimage').addEventListener('change', function(event) {
        const [file] = event.target.files;
        const previewContainer = document.getElementById('preview-container');
        const previewImage = document.getElementById('preview-image');

        if (file) {
            previewImage.src = URL.createObjectURL(file);
            previewContainer.style.display = 'block';  // show preview div
        } else {
            previewImage.src = '#';
            previewContainer.style.display = 'none';   // hide preview div if no file
        }
    });
</script>
@endsection