@extends('admin.admin-layout')

@section('content')
<!-- Start Container Fluid -->
<div class="container-xxl">
    <div class="row">
        @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show w-50" role="alert">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        @if (session('error'))
            <div class="alert alert-danger alert-dismissible fade show w-50" role="alert">
                {{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        <div class="col-xl-9 col-lg-8">
           <form action="{{route('contact-us.store')}}" method="POST">
                    @csrf

                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Company Details</h4>
                        </div>
                        <div class="card-body">
                             <!-- Company Name -->
                            <div class="mb-3">
                                <label class="form-label">Company Name</label>
                                <input type="text" name="company_name" class="form-control" value="{{ old('company_name', $companyDetail->company_name ?? '') }}">
                            </div>

                            <!-- Email -->
                            <div class="mb-3">
                                <label class="form-label">Email</label>
                                <input type="email" name="email" class="form-control" value="{{ old('email', $companyDetail->email ?? '') }}" required>
                            </div>

                            <!-- Phone -->
                            <div class="mb-3">
                                <label class="form-label">Phone</label>
                                <input type="text" name="phone" class="form-control" value="{{ old('phone', $companyDetail->phone ?? '') }}">
                            </div>

                            <!-- Address -->
                            <div class="mb-3">
                                <label class="form-label">Address</label>
                                <textarea name="address" class="form-control" rows="3">{{ old('address', $companyDetail->address ?? '') }}</textarea>
                            </div>

                        </div>
                    </div>

                    <!-- Submit -->
                    <div class="p-3 bg-light mb-3 rounded">
                        <div class="row justify-content-end g-2">
                            <div class="col-lg-2">
                                <button type="submit" class="btn btn-outline-secondary w-100">
                                    {{ isset($companyDetail) ? 'Update' : 'Save' }}
                                </button>
                            </div>
                        </div>
                    </div>
                </form>

        </div>
    </div>
</div>
@endsection
