<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>C3 - Ethnic Fashion</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="shortcut icon" href="{{ asset('assets/images/d6355990a69bcfe17bcd4d24ce5932c8cfd2c793.png') }}">

    <!-- Font Awesome CDN -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poltawski+Nowy&display=swap" rel="stylesheet">

    <!-- Main CSS File -->
    <link rel="stylesheet" href="{{ asset('css/style.css') }}">
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css"/>
    
    



  </head>

<body style="background-color: #FFF6EA;">
  @php
    use App\Models\Cart;
    use Illuminate\Support\Facades\Auth;

    $cartCount = 0;

    if (Auth::check()) {
        $cartCount = Cart::where('user_id', Auth::id())->sum('quantity');
    }
@endphp
<!-- Navbar -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<nav class="navbar sticky-top py-3" style="background-color: #fdf5ec; z-index: 1030;">
  <div class="container-fluid px-3 d-flex justify-content-between align-items-center flex-wrap">

    <!-- Left: Logo + Menu -->
    <div class="d-flex align-items-center flex-wrap">
      <!-- Logo -->
      <a class="navbar-brand p-0 m-0" href="{{ route('home') }}">
        <img src="{{ asset('images/d6355990a69bcfe17bcd4d24ce5932c8cfd2c793.png') }}" alt="Logo" style="height: 55px;">
      </a>

      <!-- Menu (No spacing between logo and nav links) -->
      <div class="d-none d-lg-flex align-items-center ms-3">
        <a class="nav-link fw-semibold text-brown px-2" href="{{ route('home') }}">
          <i class="fa-solid fa-house me-1"></i> Home
        </a>
        <a class="nav-link fw-semibold text-brown px-2" href="{{ route('Catalogue') }}">
          <i class="fa-solid fa-layer-group me-1"></i> Catalogue
        </a>
        <a class="nav-link fw-semibold text-brown px-2" href="javascript:void(0);" onclick="submitWishlistForm()">
          <i class="fa-solid fa-heart me-1"></i> Wishlist
        </a>
        @auth
          <form id="wishlistForm" action="{{ route('wishlist.product') }}" method="POST" style="display: none;">
              @csrf
          </form>
        @endauth
        <script>
            // function submitWishlistForm() {
            //     document.getElementById('wishlistForm').submit();
            // }
            function submitWishlistForm() {
                  @auth
                      // If logged in, submit the wishlist form
                      document.getElementById('wishlistForm').submit();
                  @else
                      // If not logged in, alert or redirect to login page
                      const modal = new bootstrap.Modal(document.getElementById('loginModal'));
                      modal.show();
                  @endauth
              }
        </script>
        <a href="javascript:void(0);" class="fw-semibold text-brown nav-link  px-2" data-bs-toggle="offcanvas" data-bs-target="#cart-offcanvas"><i class="fa-solid fa-cart-shopping me-1"></i> Cart
            <span class="badge bg-danger  top-0 start-100 translate-middle" id="header-count" style="font-size: 0.65rem; padding: 2px 1px 2px 1px;">
                {{ $cartCount }}
            </span>
        </a>
        <a class="nav-link fw-semibold text-brown px-2" href="{{ route('About-us') }}">
          <i class="fa-solid fa-users me-1"></i> About Us
        </a>
          @auth
              <a class="nav-link fw-semibold text-brown px-2" href="{{route('user.profile')}}">
                <i class="fa-solid fa-circle-user me-1"></i> Account
              </a>
          @endauth
      </div>
    </div>

    <!-- Right: Search + Auth Buttons -->
    <div class="d-flex align-items-center gap-2 mt-2 mt-lg-0">
      <!-- Search -->
      <div class="position-relative">
          <div class="input-group d-none d-lg-flex" style="max-width: 200px;">
            <span class="input-group-text bg-light border-end-0">
              <i class="fa-solid fa-magnifying-glass text-brown"></i>
            </span>
            <input type="text" id="search-input" class="form-control border-start-0 bg-light" placeholder="Search......" style="font-size: 0.9rem;">
          </div>

          <!-- Suggestions Dropdown -->
          <div id="suggestions" class="list-group position-absolute w-100 z-3  shadow rounded-3 border-0 " style="top: 100%; display: none;  max-height: 200px; overflow-y: auto;">
            <!-- Dynamic results here -->
          </div>
        </div>


      <!-- Login/Register -->
      @guest
        <button class="btn btn-sm px-3" style="background-color: #f4cccc; color: #5b2c2c;" data-bs-toggle="modal" data-bs-target="#loginModal">
            LOGIN / REGISTER<i class="fa-solid fa-arrow-right-to-bracket ms-1"></i>
          </button>
        @endguest
        @auth
          <a class="btn btn-sm px-3" style="background-color: #f4cccc; color: #5b2c2c;" href="{{ route('custom.logout') }}">
            LOGOUT <i class="fa-solid fa-arrow-right-to-bracket ms-1"></i>
            </a>
        @endauth

      <!-- Mobile Toggler -->
      <button class="navbar-toggler d-lg-none border-0" type="button" data-bs-toggle="offcanvas" data-bs-target="#mobileMenu">
        <i class="fa-solid fa-bars text-brown fs-4"></i>
      </button>
    </div>
  </div>
</nav>
<div class="offcanvas offcanvas-start" tabindex="-1" id="mobileMenu">
  <div class="offcanvas-header">
      <a class="navbar-brand p-0 m-0" href="{{ route('home') }}">
        <img src="{{ asset('images/d6355990a69bcfe17bcd4d24ce5932c8cfd2c793.png') }}" alt="Logo" style="height: 55px;">
      </a>
    <button type="button" class="btn-close" data-bs-dismiss="offcanvas"></button>
  </div>
  <div class="offcanvas-body d-flex flex-column gap-3">
    <a class="nav-link fw-semibold text-brown" href="{{ route('home') }}"><i class="fa-solid fa-house me-1"></i> Home</a>
    <a class="nav-link fw-semibold text-brown" href="{{ route('Catalogue') }}"><i class="fa-solid fa-layer-group me-1"></i> Catalogue</a>
    <a class="nav-link fw-semibold text-brown" href="javascript:void(0);" onclick="submitWishlistForm()"><i class="fa-solid fa-heart me-1"></i> Wishlist</a>
    <a class="nav-link fw-semibold text-brown" href="{{ route('About-us') }}"><i class="fa-solid fa-users me-1"></i> About Us</a>
    <a class="nav-link fw-semibold text-brown" href="javascript:void(0);" data-bs-toggle="offcanvas" data-bs-target="#cart-offcanvas"><i class="fa-solid fa-cart-shopping me-1"></i> Cart</a>
    @auth
      <a class="nav-link fw-semibold text-brown" href="{{route('user.profile')}}"><i class="fa-solid fa-circle-user me-1"></i> Account</a>
    @endauth
  </div>
</div>


@if(session('success'))
<!-- Success Modal -->
<div class="modal fade" id="successModal" tabindex="-1" aria-labelledby="successModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content" style="background-color: #FFF6EA; color: #652E2E; border: none; border-radius: 10px;">
      <div class="modal-body text-center py-4">
        <h5 class="modal-title mb-3" id="successModalLabel"></h5>
        <p>{{ session('success') }}</p>
        <button type="button" class="btn-close position-absolute top-0 end-0 m-3" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
    </div>
  </div>
</div>
@endif
@if(session('success'))
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const successModal = new bootstrap.Modal(document.getElementById('successModal'));
        successModal.show();

        setTimeout(() => {
            successModal.hide();
        }, 4000); // hide after 4 seconds
    });
</script>
@endif
<!--  -->
@yield('content')
<!--  -->
<footer class="custom-footer">
  <div class="footer-container">
    <!-- Left Info Columns -->
    <div class="footer-columns">
      <div class="footer-column">
        <h4>INFORMATION</h4>
        <ul>
          <li><a href="{{ route('About-us') }}">About Us</a></li>
          <li><a href="{{route('Contact-us')}}">Contact information</a></li>
          <li><a href="{{ route('Terms&condition') }}">Terms of Service</a></li>
          <li><a href="{{ route('Privacy-policy') }}">Privacy Policy</a></li>
          <li><a href="{{route('Refund-Policy')}}">Refund Policy</a></li>
          <li><a href="{{route('Shipping-Policy')}}">Shipping Policy</a></li>
        </ul>
      </div>
      <div class="footer-column">
        <h4>INFORMATION</h4>
        <ul>
          <li><a href="#" data-bs-toggle="modal" data-bs-target="#loginModal">Login</a></li>
          <li><a href="{{route('Contact-us')}}">Contact Us</a></li>
          <li><a href="{{route('FAQ-s')}}">FAQs</a></li>
          <li><a href="{{route('Refund-Policy')}}">Return & Refund</a></li>
        </ul>
      </div>
    </div>

    <!-- Login Offcanvas -->
<!-- Modal Trigger (Optional) -->
<!-- <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#loginModal">Launch Login</button> -->
@if(session('show_login_modal'))
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const loginModal = document.getElementById('loginModal');
            if (loginModal) {
                const modal = new bootstrap.Modal(loginModal);
                modal.show();
            }
        });
    </script>
@endif

<!-- Modal Structure -->
<div class="modal fade" id="loginModal" tabindex="-1" aria-labelledby="loginModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-xl">
    <div class="modal-content rounded-4 overflow-hidden" style="border: none;">
      <div class="d-flex flex-column flex-lg-row w-100" style="min-height: 500px; background: linear-gradient(180deg, #F4C2C2, #652E2E);">

        <!-- Left Side: Logo and Offer -->
        <div class="d-flex flex-column justify-content-center align-items-center text-center text-white p-5 col-lg-6">
          <img src="{{ asset('images/d6355990a69bcfe17bcd4d24ce5932c8cfd2c793.png') }}" alt="Logo" style="width: 150px; height: auto;">
          <h5 class="mt-4 fw-bold">"First-Time Here? Your Wardrobe Just<br>Got Luckier – Flat 15% OFF!"</h5>
        </div>

        <!-- Right Side: Login Form -->
        <div class="col-lg-6 p-5 d-flex justify-content-center align-items-center" >
          <div class="w-100" style="max-width: 400px; background: white; padding: 30px; border-radius: 16px; box-shadow: 0 4px 16px rgba(0,0,0,0.1);">
            <h4 class="text-center fw-bold mb-4" style="color: #652E2E;">Login / Register </h4>

            <form method="POST" action="{{ route('user.login') }}" id="loginForm">              
              @csrf
              <div class="mb-3">
                <input type="text" name="mobile" class="form-control" maxlength="10" pattern="\d{10}" title="Enter exactly 10 digits" placeholder="Enter Mobile Number"  required>
              </div>

              <div class="form-check form-switch d-flex align-items-center mb-3">
                <input class="form-check-input me-2" type="checkbox" id="notify" name="notify">
                <label class="form-check-label" for="notify" style="font-size: 0.9rem; color: #652E2E;">Notify me for any updates & offers</label>
              </div>

              <button type="submit" class="btn w-100" style="background-color: #652E2E; color: #FFF6EA;">Submit</button>

              <p class="text-center mt-3 mb-1" style="font-size: 0.85rem; color: #652E2E;">
                I accept that I have read & understood <br>
                <a href="{{route('Privacy-policy')}}" class="text-decoration-underline" style="color: #652E2E;">Privacy Policy & T&Cs.</a>
              </p>
            </form>

          </div>
        </div>

      </div>
    </div>
  </div>
</div>


<div class="modal fade" id="otpModal" tabindex="-1" aria-labelledby="otpModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-xl">
    <div class="modal-content rounded-4 overflow-hidden" style="border: none;">
      <div class="d-flex flex-column flex-lg-row w-100" style="min-height: 500px; background: linear-gradient(180deg, #F4C2C2, #652E2E);">

        <!-- Left Side -->
        <div class="d-flex flex-column justify-content-center align-items-center text-center text-white p-5 col-lg-6" >
          <img src="{{ asset('images/d6355990a69bcfe17bcd4d24ce5932c8cfd2c793.png') }}" alt="Logo" style="width: 150px; height: auto;">
          <h5 class="mt-4 fw-bold">"First-Time Here? Your Wardrobe Just<br>Got Luckier – Flat 15% OFF!"</h5>
        </div>

        <!-- Right Side -->
        <div class="col-lg-6 p-5 d-flex justify-content-center align-items-center" >
          <div class="w-100" style="max-width: 400px; background: white; padding: 30px; border-radius: 16px; box-shadow: 0 4px 16px rgba(0,0,0,0.1);">
            <h4 class="text-center fw-bold mb-3" style="color: #652E2E;">OTP Verification</h4>
            <p class="text-center mb-2" style="font-size: 0.95rem; color: #652E2E;">We have sent a verification code to</p>
         <p class="text-center fw-bold mb-3" style="color: #652E2E;">
            +91 
            <span id="otpMobileNumber" class="d-inline"></span>
            <input type="text" id="editMobileInput" class="form-control d-inline-block visually-hidden" 
                  style="width: 160px; margin-left: 8px;" maxlength="10">
            <button id="editMobileBtn" class="btn btn-sm btn-outline-success ms-2 py-0 px-2" style="font-size: 0.75rem;">
              Edit
            </button>
          </p>





            <!-- OTP Inputs -->
            <div class="d-flex justify-content-between mb-3">
              <input type="text" maxlength="1" class="form-control text-center mx-1 otp-digit" style="width: 50px; height: 50px; border: 1px solid #ccc; border-radius: 8px;">
              <input type="text" maxlength="1" class="form-control text-center mx-1 otp-digit" style="width: 50px; height: 50px; border: 1px solid #ccc; border-radius: 8px;">
              <input type="text" maxlength="1" class="form-control text-center mx-1 otp-digit" style="width: 50px; height: 50px; border: 1px solid #ccc; border-radius: 8px;">
              <input type="text" maxlength="1" class="form-control text-center mx-1 otp-digit" style="width: 50px; height: 50px; border: 1px solid #ccc; border-radius: 8px;">
            </div>

            <p class="text-center mb-3">
              <a href="#" id="resendOtpBtn" class="text-decoration-none" style="color: #652E2E;"><i class="fa fa-refresh me-1"></i>Resend OTP</a>
            </p>

            <button type="button" id="verifyOtpBtn" class="btn w-100" style="background-color: #652E2E; color: #FFF6EA;">
                Verify
            </button>
          </div>
        </div>

      </div>
    </div>
  </div>
</div>



<style>
  @media (max-width: 768px) {
    .modal-dialog {
      margin: 1rem;
    }
    .modal-content {
      border-radius: 1rem !important;
    }
  }
</style>


    @if ($errors->any() && session('form') === 'login')
      <script>
          document.addEventListener('DOMContentLoaded', function () {
              var loginCanvas = new bootstrap.Offcanvas(document.getElementById('login-offcanvas'));
              loginCanvas.show();
          });
      </script>
    @endif

<!-- Cart Offcanvas -->
<div class="offcanvas offcanvas-end custom-offcanvas" tabindex="-1" id="cart-offcanvas">
  <div class="offcanvas-header" style="background-color:#fff;">
    <h5 class="offcanvas-title text-black">Your Cart (<span id="cart-count">
        @guest
            {{ count(session('cart', [])) }}
        @else
            0
        @endguest
    </span>)</h5>
    <button type="button" class="btn border-0 p-0" data-bs-dismiss="offcanvas" aria-label="Close">
      <i class="fas fa-times fs-4 text-black"></i>
    </button>
  </div>

  <div class="offcanvas-body" style="background-color:#fff; color:#652E2E;">

    <div id="cart-items-body">
        @guest
            {{-- Show session cart --}}
            @php
                $cart = session('cart', []);
                $cartTotal = 0;
            @endphp

            @if(count($cart))
                @foreach($cart as $item)
                    @php
                        $product = \App\Models\Product::find($item['product_id']);
                        $color = \App\Models\Color::find($item['color_id']);
                        $price = $product->price - $product->discount;
                        $subtotal = $price * $item['quantity'];
                        $cartTotal += $subtotal;
                    @endphp
                    @if($product)
                        <div class="d-flex align-items-start mb-3 border-bottom pb-2">
                            <img src="{{ asset('storage/' . $product->image) }}" width="60" class="me-2 rounded">
                            <div>
                                <div class="fw-bold text-dark">{{ $product->name }}</div>
                                <div class="small">Color: {{ $color->color_name ?? 'N/A' }}</div>
                                <div class="small">Size: {{ $item['size'] }}</div>
                                <div class="small">Qty: {{ $item['quantity'] }}</div>
                                <div class="small fw-semibold">₹{{ number_format($subtotal, 2) }}</div>
                            </div>
                        </div>
                    @endif
                @endforeach
            @else
                <p class="text-muted">Your cart is empty.</p>
            @endif
        @endguest

        @auth
            {{-- JavaScript will populate this when logged in --}}
        @endauth
    </div>

    <div id="cart-summary">
      <div class="d-flex justify-content-between">
        <strong class="text-black">Total</strong>
        <strong class="text-black" id="cart-total">
            @guest
                ₹{{ number_format($cartTotal ?? 0, 2) }}
            @else
                ₹0.00
            @endguest
        </strong>
      </div>

     @php
          $cartCount = 0;

          if (auth()->check()) {
              // Logged-in user: fetch cart from DB
              $cartCount = \App\Models\Cart::where('user_id', auth()->id())->sum('quantity');
          } else {
              // Guest: count session cart items
              $sessionCart = session('cart', []);
              foreach ($sessionCart as $item) {
                  $cartCount += $item['quantity'];
              }
          }
      @endphp

      @if($cartCount > 0)
          <a href="{{ auth()->check() ? url('/checkout') : url('/login') }}" id="checkout-btn" class="btn w-100 mt-3" style="background-color:#652E2E; color:#FFF6EA;">
              PROCEED TO CHECKOUT
          </a>
      @else
          <a href="{{ url('/New-Arrival') }}" class="btn w-100 mt-3" style="background-color:#652E2E; color:#FFF6EA;">
              Shop Now
          </a>
      @endif
    </div>
  </div>
</div>



<!-- Success Modal (hidden by default) -->
<div class="modal fade" id="successModal" tabindex="-1" aria-labelledby="successModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content" style="background-color: #FFF6EA; color: #652E2E; border: none; border-radius: 10px;">
      <div class="modal-body text-center py-4">
        <h5 class="modal-title mb-3" id="successModalLabel"></h5>
        <p id="successModalMessage"></p>
        <div id="modalActionButton" class="d-none">
          <a href="#" id="goToCartBtn" class="btn  border px-4" data-bs-toggle="offcanvas" data-bs-target="#cart-offcanvas" style="background-color:#652E2E;color: #FFF6EA;">Go to Cart <i class="fa-solid fa-cart-shopping me-2" style="font-size: 1.2rem;"></i></a>
        </div>
        <button type="button" class="btn-close position-absolute top-0 end-0 m-3" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
    </div>
  </div>
</div>


    <!-- Newsletter & Social -->
    <div class="footer-right">
      <h4>NEWSLETTER</h4>
      <p class="newsletter-text">Subscribe to receive update, access to exclusive deals, and get 10% off coupon.</p>
      <h4>KEEP IN TOUCH</h4>
      <div class="footer-icons">
          <a href="https://www.youtube.com/@YourChannelName" class="icon-link" target="_blank">
              <i class="fab fa-youtube"></i>
          </a>
          <a href="https://www.facebook.com/YourPageName" class="icon-link" target="_blank">
              <i class="fab fa-facebook-f"></i>
          </a>
          <a href="https://wa.me/919999999999" class="icon-link" target="_blank">
              <i class="fab fa-whatsapp"></i>
          </a>
          <a href="https://www.instagram.com/YourUsername/" class="icon-link" target="_blank">
              <i class="fab fa-instagram"></i>
          </a>
          <a href="mailto:your@email.com" class="icon-link">
              <i class="fas fa-envelope"></i>
          </a>
      </div>
    </div>

    <!-- Logo -->
    <div class="footer-logo">
      <a href="{{route('home')}}">
        <img src="{{ asset('images/d6355990a69bcfe17bcd4d24ce5932c8cfd2c793.png') }}" alt="C3 Logo">
      </a>
    </div>
  </div>

  <!-- Copyright -->
  <div class="footer-bottom text-center">
    © 2025. All Rights Reserved | Developed by SCHOTECH
  </div>
</footer>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js"></script>
    <script>
      window.auth = {
            isLoggedIn: @json(auth()->check())
        };
    </script>

</body>

</html>
<!-- -------------------------------------------------------------------------------------------------------------------- -->

<script>
  const buttons = document.querySelectorAll('.btn.custom');
  const products = document.querySelectorAll('.product-item');

  // Function to show products by category
  function filterProducts(category) {
    products.forEach(product => {
      if (category === 'all' || product.getAttribute('data-category') === category) {
        product.style.display = 'block';
      } else {
        product.style.display = 'none';
      }
    });
  }

  // Function to update active button styling
  function setActiveButton(activeBtn) {
    buttons.forEach(btn => btn.classList.remove('active'));
    activeBtn.classList.add('active');
  }

   // On page load, activate first category button and filter
  window.addEventListener('DOMContentLoaded', () => {
    const firstBtn = Array.from(buttons).find(btn => btn.getAttribute('data-category') !== 'all');
    if (firstBtn) {
      const category = firstBtn.getAttribute('data-category');
      setActiveButton(firstBtn);
      filterProducts(category);
    }
  });
  
  // Show "printed" category products by default on page load
  window.addEventListener('DOMContentLoaded', () => {
    // Find the "Printed Suits" button and activate it
    const defaultBtn = Array.from(buttons).find(btn => btn.getAttribute('data-category') === 'printed');
    if (defaultBtn) {
      setActiveButton(defaultBtn);
      filterProducts('printed');
    }
  });

  // Filter products on button click and set active class
  buttons.forEach(button => {
    button.addEventListener('click', () => {
      const category = button.getAttribute('data-category');
      filterProducts(category);
      setActiveButton(button);
    });
  });
</script>
<script>
  $(document).ready(function(){
    $('.category-slider').slick({
      autoplay: true,
      autoplaySpeed: 2000,
      infinite: true,
      arrows: false,
      slidesToShow: 2,  // Default for smallest screens
      slidesToScroll: 1,
      responsive: [
        {
          breakpoint: 576, // up to 575.98px
          settings: {
            slidesToShow: 2
          }
        },
        {
          breakpoint: 768, // 576px to 767.98px
          settings: {
            slidesToShow: 2
          }
        },
        {
          breakpoint: 992, // 768px to 991.98px
          settings: {
            slidesToShow: 3
          }
        },
        {
          breakpoint: 1200, // 992px to 1199.98px
          settings: {
            slidesToShow: 4
          }
        },
        {
          breakpoint: 1400, // 1200px to 1399.98px
          settings: {
            slidesToShow: 5
          }
        },
        {
          breakpoint: 10000, // anything larger than 1400px
          settings: {
            slidesToShow: 6
          }
        }
      ]
    });
  });
</script>




<!-- -------------------------------------------------------------------------------------------------------------------- -->

<script>
  $(document).ready(function(){
    $('.style-carousel').slick({
      slidesToShow: 3,
      slidesToScroll: 1,
      autoplay: true,
      autoplaySpeed: 2000,
      arrows: false,
      dots: false,
      responsive: [
        {
          breakpoint: 992,
          settings: {
            slidesToShow: 2
          }
        },
        {
          breakpoint: 768,
          settings: {
            slidesToShow: 1
          }
        }
      ]
    });
  });
</script>
<!-- -------------------------------------------------------------------------------------------------------------------- -->
<script>
  $(document).ready(function(){
    $('.scrolling-wrapper').slick({
      slidesToShow: 4,
      slidesToScroll: 1,
      autoplay: true,
      autoplaySpeed: 2000,
      arrows: false,
      dots: false,
      responsive: [
        {
          breakpoint: 992,
          settings: {
            slidesToShow: 2
          }
        },
        {
          breakpoint: 768,
          settings: {
            slidesToShow: 1
          }
        }
      ]
    });
  });
</script>
<script>
  $(document).ready(function(){
    $('.similar-products-scroll').slick({
      slidesToShow: 4,
      slidesToScroll: 1,
      autoplay: true,
      autoplaySpeed: 2000,
      arrows: false,
      dots: false,
      responsive: [
        {
          breakpoint: 992,
          settings: {
            slidesToShow: 2
          }
        },
        {
          breakpoint: 768,
          settings: {
            slidesToShow: 1
          }
        }
      ]
    });
  });
</script>
<!-- -------------------------------------------------------------------------------------------------------------------- -->

<script>
function loadCartItems() {
  $.ajax({
    url: "{{ route('cart.fetch') }}",
    method: 'GET',
    success: function(res) {
      if (res.status === 'success') {
        $('#cart-count').text(res.cartCount);
        $('#header-count').text(res.cartCount);
        $('#cart-total').text('₹ ' + parseFloat(res.cartTotal).toFixed(2));

        let html = '';

        if (res.cartItems.length === 0) {
          html = `
            <div class="text-center py-4">
              <h5 class="text-muted mb-3">No Products in the Cart.</h5>
              <a href="{{ route('New-Arrival') }}" class="btn" style="background-color:#652E2E; color:#FFF6EA;">Continue Shopping</a>
            </div>`;
          $('#cart-summary').hide(); // ⛔ Hide total and checkout
        } else {
          res.cartItems.forEach(item => {
            html += `
              <div class="d-flex mb-3">
                <img src="${item.image}" class="img-fluid me-3" style="width: 80px; height: 100px;">
                <div>
                  <h6 class="mb-1">${item.name}</h6>
                  <small class="text-black">Qty: ${item.quantity}</small><br>
                  ${
                      item.selected_color_name
                        ? `<small class="text-muted">Color: ${item.selected_color_name}</small><br>`
                        : `
                          <label class="form-label mb-0">
                            <small class="text-muted">Select Color:</small>
                          </label>
                          <select class="form-select form-select-sm mb-1 select-color" data-id="${item.id}" required>
                            <option value="">-- Select Color --</option>
                            ${item.available_colors.map(color => `
                              <option value="${color.id}">${color.name}</option>
                            `).join('')}
                          </select>
                          <div class="text-danger small d-none color-error-${item.id}">Please select a color.</div>
                        `
                    }

                    ${
                      item.selected_size
                        ? `<small class="text-muted">Size: ${item.selected_size}</small><br>`
                        : `
                          <label class="form-label mb-0">
                            <small class="text-muted">Select Size:</small>
                          </label>
                          <select class="form-select form-select-sm mb-1 select-size" data-id="${item.id}" required>
                            <option value="">-- Select Size --</option>
                            ${item.available_sizes.map(size => `
                              <option value="${size}">${size}</option>
                            `).join('')}
                          </select>
                          <div class="text-danger small d-none size-error-${item.id}">Please select a size.</div>
                        `
                    }
                          
                  <small class="text-black">₹ ${parseFloat(item.price).toFixed(2)}</small>
                  ${
                  window.auth.isLoggedIn
          ? `
                  <div class="d-flex align-items-center gap-3 mt-2">
                    <div class="border d-flex align-items-center" style="height: 38px;">
                      <button class="btn border-end px-3 py-1 btn-decrease" data-id="${item.id}" data-qty="${item.quantity}">-</button>
                      <input type="text" class="form-control text-center border-0 px-2 cart-qty" value="${item.quantity}" style="width: 40px;" readonly>
                      <button class="btn border-start px-3 py-1 btn-increase" data-id="${item.id}" data-qty="${item.quantity}">+</button>
                    </div>
                    <button class="btn p-3 btn-remove-item" style="background: none;" data-id="${item.id}">
                      <i class="fas fa-trash-alt fs-5 icon-delete-cart"></i>
                    </button>
                  </div>
                   `
          : ''
                  }
                </div>
              </div>`;
          });

          $('#cart-summary').show(); // ✅ Show total and checkout
        }

        $('#cart-items-body').html(html);
      } else {
        $('#cart-items-body').html('<p class="text-danger">Error loading cart.</p>');
        $('#cart-summary').hide(); // Safety fallback
      }
    }
  });
}



// ➕ Increase quantity
$(document).on('click', '.btn-increase', function() {
  let id = $(this).data('id');
  let currentQty = parseInt($(this).data('qty'));
  updateCartQuantity(id, currentQty + 1);
});

// ➖ Decrease quantity
$(document).on('click', '.btn-decrease', function() {
  let id = $(this).data('id');
  let currentQty = parseInt($(this).data('qty'));
  if (currentQty > 1) {
    updateCartQuantity(id, currentQty - 1);
  }
});

//  Remove item
$(document).on('click', '.btn-remove-item', function() {
  let id = $(this).data('id');
  $.post("{{ route('cart.remove') }}", {
    _token: "{{ csrf_token() }}",
    product_id: id
  }, function(res) {
    if (res.status === 'success') {
      loadCartItems();
    }
  });
});

//  Update cart with quantity
function updateCartQuantity(productId, newQty) {
  $.post("{{ route('cart.update') }}", {
    _token: "{{ csrf_token() }}",
    product_id: productId,
    quantity: newQty
  }, function(res) {
    if (res.status === 'success') {
      loadCartItems();
    } else {
      alert(res.message || 'Error updating cart');
    }
  });
}

// 🎯 When color is selected
$(document).on('change', '.select-color', function() {
  const productId = $(this).data('id');
  const colorId = $(this).val();

  if (colorId !== '') {
    $.post("{{ route('cart.update.color') }}", {
      _token: "{{ csrf_token() }}",
      product_id: productId,
      color_id: colorId
    }, function(res) {
      if (res.status === 'success') {
        loadCartItems(); // reload cart with updated color
      }
    });
  }
});

// 🎯 When size is selected
$(document).on('change', '.select-size', function() {
  const productId = $(this).data('id');
  const size = $(this).val();

  if (size !== '') {
    $.post("{{ route('cart.update.size') }}", {
      _token: "{{ csrf_token() }}",
      product_id: productId,
      size: size
    }, function(res) {
      if (res.status === 'success') {
        loadCartItems(); // reload cart with updated size
      }
    });
  }
});


//  Load when offcanvas opens
$('#cart-offcanvas').on('show.bs.offcanvas', function () {
  loadCartItems();
});


//  VAlidation of cart colour field and size field
function validateCartSelections() {
  let isValid = true;

  $('.select-color').each(function () {
    const productId = $(this).data('id');
    if ($(this).val() === "") {
      $(`.color-error-${productId}`).removeClass('d-none');
      isValid = false;
    } else {
      $(`.color-error-${productId}`).addClass('d-none');
    }
  });

  $('.select-size').each(function () {
    const productId = $(this).data('id');
    if ($(this).val() === "") {
      $(`.size-error-${productId}`).removeClass('d-none');
      isValid = false;
    } else {
      $(`.size-error-${productId}`).addClass('d-none');
    }
  });

  return isValid;
}


$(document).on('click', '#checkout-btn', function(e) {
  if (!validateCartSelections()) {
    e.preventDefault(); // ⛔ stop navigation
  }
});

</script>
<!-- ------------------------------------------------------------------------------------------------------------------- -->
<script>
document.addEventListener('DOMContentLoaded', function () {
    const loginForm = document.getElementById('loginForm');

    if (loginForm) {
        loginForm.addEventListener('submit', function (e) {
            e.preventDefault();

            const formData = new FormData(loginForm);

            fetch("{{ route('user.login') }}", {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': "{{ csrf_token() }}"
                },
                body: formData
            })
            .then(res => res.json())
            .then(data => {
                if (data.status === 'otp_required') {
                    document.getElementById('otpMobileNumber').innerText = data.mobile;

                    isNewUser = data.is_new_user; // ✅ save this here

                    const otpModal = new bootstrap.Modal(document.getElementById('otpModal'));
                    otpModal.show();
                } else if (data.status === 'success') {
                    window.location.href = "{{ route('home') }}";
                } else if (data.status === 'error') {
                    const errorMessages = Object.values(data.errors).flat().join('\n');
                    alert("Login failed:\n" + errorMessages);
                }
            })
            .catch(error => {
                console.error('Login request failed:', error);
                alert('Something went wrong. Please try again.');
            });
        });
    }

    // OTP verify handler
    document.getElementById('verifyOtpBtn').addEventListener('click', function (e) {
        e.preventDefault();

        let otp = '';
        document.querySelectorAll('.otp-digit').forEach(input => {
            otp += input.value.trim();
        });

        if (otp.length !== 4 || isNaN(otp)) {
            alert("Please enter a valid 4-digit OTP.");
            return;
        }

        fetch('{{ route("otp.verify") }}', {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({ otp: otp, is_new_user: isNewUser }) // ✅ use global value
        })
        .then(res => res.json())
        .then(data => {
            if (data.status === 'success') {
                window.location.href = data.redirect;
            } else {
                alert("Invalid OTP. Please try again.");
            }
        })
        .catch(err => {
            // console.error('OTP Verify error:', err);
            alert("Something went wrong. Please try again.");
        });
    });
});
</script>

</script>
<!-- -------------------------------------------------------------------------------------------------------------------- -->
<!-- -------------------------------------------------------------------------------------------------------------------- -->
<!-- Resend Otp Script -->

<script>
let resendCooldown = 30; // seconds

function startResendCooldown(button) {
    button.disabled = true;
    let originalText = button.innerHTML;
    let countdown = resendCooldown;

    let interval = setInterval(() => {
        button.innerHTML = `<i class="fa fa-clock me-1"></i>Resend in ${countdown}s`;
        countdown--;

        if (countdown < 0) {
            clearInterval(interval);
            button.innerHTML = originalText;
            button.disabled = false;
        }
    }, 1000);
}

document.getElementById('resendOtpBtn').addEventListener('click', function(e) {
    e.preventDefault();

    const mobile = document.getElementById('otpMobileNumber').innerText.trim();
    const button = this;

    fetch('{{ route("otp.resend") }}', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}',
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({ mobile: mobile })
    })
    .then(res => res.json())
    .then(data => {
        if (data.status === 'otp_resent') {
            // alert("OTP has been sent to " + data.mobile + ": " + data.otp); // remove in production
            startResendCooldown(button);
        } else {
            alert("Failed to resend OTP: " + JSON.stringify(data.errors));
        }
    });
});
</script>
<script>
const editBtn = document.getElementById('editMobileBtn');
const mobileSpan = document.getElementById('otpMobileNumber');
const mobileInput = document.getElementById('editMobileInput');

function startResendCooldown(button) {
    button.disabled = true;
    let countdown = 30;
    const originalText = button.innerHTML;

    const interval = setInterval(() => {
        button.innerHTML = `<i class="fa fa-clock me-1"></i>Resend in ${countdown}s`;
        countdown--;

        if (countdown < 0) {
            clearInterval(interval);
            button.innerHTML = originalText;
            button.disabled = false;
        }
    }, 1000);
}

function resendOtp(mobile, button = null) {
    fetch('{{ route("otp.resend") }}', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}',
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({ mobile: mobile })
    })
    .then(res => res.json())
    .then(data => {
        if (data.status === 'otp_resent') {
            alert("OTP resent to " + data.mobile + ": " + data.otp); // remove in production
            if (button) startResendCooldown(button);
        } else {
            alert("Resend failed: " + JSON.stringify(data.errors));
        }
    });
}

editBtn.addEventListener('click', function(e) {
    e.preventDefault();

    if (mobileInput.classList.contains('visually-hidden')) {
        // Switch to edit mode
        mobileInput.value = mobileSpan.innerText.trim();
        mobileSpan.classList.add('visually-hidden');
        mobileInput.classList.remove('visually-hidden');
        editBtn.innerText = 'Save';
    } else {
        // Save new number
        const newNumber = mobileInput.value.trim();
        const isValid = /^[6-9]\d{9}$/.test(newNumber);

        if (isValid) {
            mobileSpan.innerText = newNumber;
            mobileSpan.classList.remove('visually-hidden');
            mobileInput.classList.add('visually-hidden');
            editBtn.innerText = 'Edit';

            // Auto resend OTP after saving
            resendOtp(newNumber);
        } else {
            alert('Please enter a valid 10-digit  mobile number');
        }
    }
});
</script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const otpInputs = document.querySelectorAll('.otp-digit');

    // Auto-focus next box
    otpInputs.forEach((input, index) => {
        input.addEventListener('input', function () {
            if (this.value.length === 1 && index < otpInputs.length - 1) {
                otpInputs[index + 1].focus();
            }
        });
    });

    // Allow paste of full OTP
    otpInputs.forEach((input, index) => {
        input.addEventListener('paste', function (e) {
            const pasted = e.clipboardData.getData('text').replace(/\D/g, '');
            if (pasted.length === otpInputs.length) {
                e.preventDefault();
                [...pasted].forEach((char, i) => {
                    otpInputs[i].value = char;
                });
                otpInputs[otpInputs.length - 1].focus();
            }
        });
    });

    // Clear OTP fields on modal open
    const otpModalEl = document.getElementById('otpModal');
    otpModalEl.addEventListener('show.bs.modal', () => {
        otpInputs.forEach(input => input.value = '');
        otpInputs[0].focus();
    });
});
</script>
<!-- --------------------------------------------------------------------------------------------------------------- -->
 
<script>
$(document).ready(function () {
  $('.wishlist-toggle').click(function () {
    let productId = $(this).data('product-id');
    let icon = $(this).find('i');

    $.ajax({
      url: "{{ route('wishlist.toggle') }}",
      type: "POST",
      data: {
        _token: '{{ csrf_token() }}',
        product_id: productId
      },
      success: function (res) {
        if (res.status === 'added') {
          icon.removeClass('fa-regular').addClass('fa-solid text-brown');
        } else if (res.status === 'removed') {
          icon.removeClass('fa-solid text-brown').addClass('fa-regular');
        }
      },
      error: function (xhr) {
        if (xhr.status === 401) {
          const modal = new bootstrap.Modal(document.getElementById('loginModal'));
          modal.show();
        }
      }
    });
  });
});
</script>

<!-- ------------------------------------------------------------------------------------------------ -->
<!-- Ajax for Search  -->
<script>
document.addEventListener("DOMContentLoaded", function () {
  const searchInput = document.getElementById("search-input");
  const suggestionsBox = document.getElementById("suggestions");

  searchInput.addEventListener("keyup", function () {
    const query = this.value.trim();

    if (query.length > 0) {
      const searchUrl = "{{ url('/search-suggestions') }}";
      fetch(`${searchUrl}?q=${encodeURIComponent(query)}`)
        .then(response => response.json())
        .then(data => {
          suggestionsBox.innerHTML = "";

          if (data.length > 0) {
            data.forEach(item => {
              const option = document.createElement("a");
              const productDetailUrl = "{{ url('/product-Detail') }}";
              option.classList.add("list-group-item", "list-group-item-action");
              option.href = `${productDetailUrl}/${item.id}`;
              option.textContent = item.name;
              suggestionsBox.appendChild(option);
            });
            suggestionsBox.style.display = "block";
          } else {
            suggestionsBox.style.display = "none";
          }
        });
    } else {
      suggestionsBox.style.display = "none";
    }
  });

  // Hide on outside click
  document.addEventListener("click", function (e) {
    if (!searchInput.contains(e.target) && !suggestionsBox.contains(e.target)) {
      suggestionsBox.style.display = "none";
    }
  });
});
</script>
