@extends('layouts/layout')

@section('content')
  <div class="privacy-policy mt-8">
      @foreach($categories as $category)
          @if($category->faqs->count())
              <h3 class="fw-bold text-dark mb-3">{{ $category->name }}</h3>
              <hr>
              @foreach($category->faqs as $faq)
                  <h5 >{{ $faq->question }}</h5>
                  <p>{!! $faq->answer !!}</p>
              @endforeach
          @endif
      @endforeach
      <hr>
      <h3 class="fw-bold text-dark mb-3">Need Help?</h3>
      <p>We’re always here to help with any shipping-related questions.</p>
      @foreach($companyDetail as $Detail)
                  <strong>Email:</strong> <a href="mailto:{{ $Detail->email }}">{{ $Detail->email }}</a><br>
                  <strong>Phone/WhatsApp:</strong> 
                  <a href="tel:{{ $Detail->phone }}">{{ $Detail->phone }}</a><br>
      @endforeach

  </div>
@endsection
       