@extends('layouts/layout')

@section('content')
<div class="wishlist-section py-5 bg-white">
  <div class="container">

    <!-- Heading -->
    <div class="d-flex justify-content-between align-items-center px-2">
        <h3 class="text-start" style="color: #652E2E; margin-left: 10px;">Checkout Page</h3>
        <i class="fa-solid fa-bag-shopping" style="color: #652E2E; font-size: 20px; margin-right: 10px;"></i>
    </div>
    <hr class="underline-checklist">

    <div class="row g-4">
      <!-- Left Column: Form Section -->
        <div class="col-md-6">
            <div class="form-section p-4 bg-white shadow-sm rounded">
                <div class="d-flex justify-content-between align-items-center px-2">
                    <p><strong class="form-title">Account:</strong><br>{{ $user->name }}</p>
                    <i class="fa-solid fa-user" style="color: #652E2E; font-size: 20px; margin-right: 10px;"></i>
                </div>
                <hr>
                <p class="form-title">Delivery</p>

                <form id="checkout-form" method="POST" action="{{ route('checkout.store') }}">
                    @csrf

                    <div class="mb-3">
                        <label class="form-label">Country/Region</label>
                        <select class="form-select" name="country">
                            <option value="India" selected>India</option>
                        </select>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                        <input type="hidden" name="razorpay_payment_id" id="razorpay_payment_id">

                            <label class="form-label">First Name</label>
                            <input type="text" class="form-control" name="first_name" required
                                value="{{ old('first_name', explode(' ', $user->name)[0]) }}">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Last Name</label>
                            <input type="text" class="form-control" name="last_name" required
                                value="{{ old('last_name', explode(' ', $user->name)[1] ?? '') }}">
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Address</label>
                        <input type="text" class="form-control" name="address" required
                            value="{{ old('address', $user->address ?? '') }}">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Apartment, suite, etc. (optional)</label>
                        <input type="text" class="form-control" name="apartment"
                            value="{{ old('apartment') }}">
                    </div>

                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label class="form-label">City</label>
                            <input type="text" class="form-control" name="city" required
                                value="{{ old('city', $user->city ?? '') }}">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">State</label>
                            <select class="form-select" name="state" required>
                                <option value="" disabled {{ old('state') ? '' : 'selected' }}>Select State</option>
                                <option value="Maharashtra" {{ old('state', $user->state ?? '') == 'Maharashtra' ? 'selected' : '' }}>Maharashtra</option>
                                <option value="Delhi" {{ old('state', $user->state ?? '') == 'Delhi' ? 'selected' : '' }}>Delhi</option>
                                <option value="Karnataka" {{ old('state', $user->state ?? '') == 'Karnataka' ? 'selected' : '' }}>Karnataka</option>
                                <!-- Add other states -->
                            </select>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">PIN code</label>
                            <input type="text" class="form-control" name="pincode" required
                                    pattern="\d{6}" minlength="6" maxlength="6"
                                    value="{{ old('pincode', $user->pincode ?? '') }}">
                        </div>
                    </div>

                    <div class="mb-4">
                        <label class="form-label">Phone</label>
                        <input type="text" class="form-control" name="phone" required
                                pattern="\d{10}" minlength="10" maxlength="10"
                                value="{{ old('phone', $user->phone ?? '') }}">
                    </div>

                    <input type="hidden" name="coupon_code" id="coupon_code_input">
                    <input type="hidden" name="coupon_discount" id="coupon_discount">


                    <button type="submit" id="pay-now-btn" class="btn pay-btn w-100">Pay Now</button>
                </form>
            </div>
        </div>



      <!-- Right Column: Summary Section -->
      <div class="col-md-6 ">
         <div class="summary-section p-4 bg-light shadow-sm rounded ">
                @foreach($cartItems as $item)
                        <div class="row">
                            <div class="product-item mb-3 p-2 border rounded d-flex  justify-content-between flex-wrap flex-md-nowrap">
                                <!-- Image and Badge -->
                                <div class="position-relative me-3">
                                    <div class="image-badge-wrapper">
                                        <img src="{{ asset('storage/' . $item->product->image) }}" alt="Product" class="product-image">
                                        <span class="badge badge-overlay">{{ $item->quantity }}</span>
                                    </div>
                                </div>

                                <!-- Product Name and Size/Color -->
                                <div class="flex-grow-1" style="min-width: 180px;">
                                    <div><strong>{{ $item->product->name }}</strong></div>
                                    <small>{{ $item->product_size }} / {{ $item->color_name }}</small>
                                </div>

                                <!-- Price -->
                                <div class="text-end" style="min-width: 80px;">
                                    <strong>₹{{ number_format($item->product->price - $item->product->discount * $item->quantity, 2) }}</strong>
                                </div>
                            </div>
                            </div>
                    @endforeach

                    <div class="discount-box mb-3">
                        <div class="input-group">
                            <input type="text" id="coupon_code" class="form-control" placeholder="Discount code">
                            <button id="apply_coupon_btn" class="btn btn-outline-dark apply-btn">Apply</button>
                        </div>
                        <small id="coupon_message" class="mt-2 d-block"></small>
                    </div>

                    <!-- Discount and Total Summary -->
                    <div id="discount-summary">
                            <div class="d-flex justify-content-between">
                                <span>Subtotal</span>
                                <span>₹{{ number_format($subtotal, 2) }}</span>
                            </div>
                            <div id="discount_line"></div>
                            <div class="d-flex justify-content-between">
                                <span>Shipping</span>
                                <span>FREE</span>
                            </div>
                            <hr>
                            <div class="d-flex justify-content-between fw-bold">
                                <span>Total</span>
                                <span id="total_amount">INR ₹{{ number_format($subtotal, 2) }}</span>
                            </div>
                        </div>
            </div>
      </div>
  </div>


  </div>
</div>
<script src="https://checkout.razorpay.com/v1/checkout.js"></script>
<script>
document.querySelector('.pay-btn').addEventListener('click', function (event) {
    event.preventDefault();

    const form = document.getElementById('checkout-form');

    // Basic form validation
    if (!form.checkValidity()) {
        form.reportValidity();
        return;
    }

    // Get latest total from the DOM (after coupon applied)
    let totalText = document.getElementById('total_amount').textContent;
    let totalAmount = parseFloat(totalText.replace(/[^0-9.]/g, ''));

    const options = {
        key: "rzp_test_LiJg1Ic8GSEZlY", // Replace with your live key in production
        amount: Math.round(totalAmount * 100), // Convert to paisa
        currency: "INR",
        name: "{{ config('app.name') }}",
        description: "Order Payment",
        handler: function (response) {
            document.getElementById('razorpay_payment_id').value = response.razorpay_payment_id;
            form.submit();
        },
        prefill: {
            name: "{{ $user->name }}",
            email: "{{ $user->email }}",
            contact: "{{ $user->phone ?? '' }}"
        },
        theme: {
            backgroundColor: "#e6f0ff",
            color: "#003380",
        }
    };

    const rzp = new Razorpay(options);
    rzp.open();
});

</script>




@endsection
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function() {
        // Store the original subtotal when page loads
        let originalSubtotal = {{ $subtotal }};

        $('#apply_coupon_btn').click(function (e) {
            e.preventDefault();
            
            let couponCode = $('#coupon_code').val();

            $.ajax({
                url: "{{ route('apply.coupon.ajax') }}",
                method: "POST",
                data: {
                    _token: "{{ csrf_token() }}",
                    coupon_code: couponCode,
                    subtotal: originalSubtotal
                },
                success: function (response) {
                    if (response.status === 'success') {
                        $('#coupon_message').text(response.message).removeClass('text-danger').addClass('text-success');

                        $('#discount_line').html(`
                            <div class="d-flex justify-content-between text-success">
                                <span>Discount (${response.code})</span>
                                <span>- ₹${response.discount}</span>
                            </div>
                        `);

                        $('#total_amount').text(`INR ₹${response.newTotal}`);

                        // ✅ Update hidden input fields
                        $('#coupon_code_input').val(response.code);
                        $('#coupon_discount').val(response.discount);
                    } else {
                        $('#coupon_message').text(response.message).removeClass('text-success').addClass('text-danger');
                        $('#discount_line').html('');
                        // Reset total to original subtotal when invalid coupon entered
                        $('#total_amount').text(`INR ₹${originalSubtotal.toFixed(2)}`);
                    }
                },
                error: function(xhr) {
                    $('#coupon_message').text("Server error").addClass('text-danger');
                    // Reset total to original subtotal on error
                    $('#total_amount').text(`INR ₹${originalSubtotal.toFixed(2)}`);
                }
            });
        });
    });
</script>

<style>
  body {
    background-color: #fdfdfd;
    font-family: 'Poltawski Nowy', serif !important;
  }
  .form-title {
    font-weight: bold;
    font-size: 20px;
    margin-bottom: 20px;
    color: #672c2c !important;
  }
  .pay-btn,.apply-btn {
    background-color: #672c2c !important;
    color: white !important;
  }
  .pay-btn:hover, .apply-btn:hover {
    background-color: #FFF6EA !important;
    color: #672c2c !important;
  }
  .product-item {
    display: flex;
    align-items: center;
    gap: 15px;
  }
  .product-item img {
    width: 60px;
    height: 80px;
    object-fit: cover;
  }
  .discount-box {
    display: flex;
    gap: 10px;
  }
  .underline-checklist {
    margin-bottom: 10px;
  }

  /* Responsive Tweaks */
  @media (max-width: 768px) {
    .product-item {
      flex-direction: column;
      align-items: flex-start;
    }
    .product-item img {
      margin-bottom: 10px;
    }
    .discount-box {
      flex-direction: column;
    }
  }
.image-badge-wrapper {
  position: relative;
  display: inline-block;
  border-radius: 10px;
  /* overflow: hidden; REMOVE this line to fix badge clipping */
}

.product-image {
  width: 60px !important;
  height: 80px !important;
  display: block !important;
  border-radius: 10px !important;
  object-fit: fill !important;
}

.badge-overlay {
  position: absolute;
  top: 2;
  right: 2;
  transform: translate(50%, -50%);
  background-color: #5a2a2a;
  color: white;
  border-radius: 55% !important;
  padding: 8px 13px;
  font-size: 18px;
  font-weight: bold;
  box-shadow: 0 2px 6px rgba(0, 0, 0, 0.2);
  z-index: 10; /* ensure it's on top */
}

 .logout-box {
            display: none; /* ✅ Hidden on load */
        }

        .logout-box a {
            text-decoration: none;
            color: #652E2E;
        }

        .dropdown-container {
            position: relative;
            display: inline-block;
        }
</style>
