@extends('admin.admin-layout')

@section('content')
<!-- Start Container Fluid -->
<div class="container-xxl">


    <!-- Feeds Table -->
    <div class="row mt-4">
        <div class="col-xl-12">
            <div class="card">
                <div class="d-flex card-header justify-content-between align-items-center">
                    <h4 class="card-title">Instagram Feeds</h4>
                    <div class="d-flex gap-2">
                            <a href="{{route('admin.dashboard') }}" class="btn btn-sm btn-secondary">← Back</a>
                            <a href="{{route('Add.Insta.Feed')}}" class="btn btn-sm btn-primary">
                                Add New Post
                            </a>
                     </div>
                </div>

                <div class="table-responsive">
                    <table class="table align-middle mb-0 table-hover table-centered">
                        <thead class="bg-light-subtle">
                            <tr>
                                <th>#</th>
                                <th>Embedded Post</th>
                                <th>Date Added</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($feeds as $index => $feed)
                                <tr>
                                    <td>#</td>
                                    <td style="max-width: 220px;">
                                        <div class="instagram-embed-wrapper" style="overflow: hidden; width: 100%; height: 30%;">
                                            {!! $feed->embed_link !!}
                                        </div>
                                    </td>

                                    <td>{{ $feed->created_at->format('d M Y, h:i A') }}</td>
                                    <td>
                                        <form action="{{ route('instagram.delete', $feed->id) }}" method="POST" class="d-inline delete-form">
                                            @csrf
                                            @method('DELETE')
                                            <button type="button" class="btn btn-sm btn-danger sweetalert-delete-btn">Delete</button>
                                        </form>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="4" class="text-center">No Instagram feeds found.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <div class="card-footer border-top">
                    {{ $feeds->links() }}
                </div>
            </div>
        </div>
    </div>

</div>
<!-- End Container Fluid -->

<!-- SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const deleteButtons = document.querySelectorAll('.sweetalert-delete-btn');

    deleteButtons.forEach(button => {
        button.addEventListener('click', function (e) {
            e.preventDefault();
            const form = this.closest('form');

            Swal.fire({
                title: 'Are you sure?',
                text: "This feed will be permanently deleted!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, delete it!',
                cancelButtonText: 'No, cancel!',
                customClass: {
                    confirmButton: 'btn btn-primary w-xs me-2 mt-2',
                    cancelButton: 'btn btn-danger w-xs mt-2'
                },
                buttonsStyling: false
            }).then((result) => {
                if (result.isConfirmed) {
                    form.submit();
                }
            });
        });
    });
});
</script>
@endsection
