@extends('admin.admin-layout')

@section('content')

<!-- Start Container Fluid -->
<div class="container-xxl">


    <div class="row mt-4">
        <div class="col-xl-12">
             @if (session('success'))
                <div class="alert alert-success alert-dismissible fade show " role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif
            @if (session('error'))
                <div class="alert alert-danger alert-dismissible fade show " role="alert">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif
            <div class="card">
                <div class="d-flex card-header justify-content-between align-items-center">
                    <div>
                        <h4 class="card-title">All FAQ's </h4>
                    </div>
                    <div class="dropdown">
                        <a href="{{route('FAQs.Add')}}" class="btn btn-sm btn-primary">Add FAQs</a>
                        <a href="{{route('admin.dashboard') }}" class="btn btn-sm btn-secondary">← Back</a>
                    </div>
                </div>
                <div>
                    <div class="table-responsive">
                        <table class="table align-middle mb-0 table-hover table-centered">
                                <thead class="bg-light-subtle">
                                    <tr>
                                        <th>#</th>
                                        <th>Question</th>
                                        <th>Answer</th>
                                        <th>FAQ Category</th>
                                        <th>Created At</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($faqs as $faq)
                                        <tr>
                                            <td>#</td>
                                            <td>
                                                <a href="{{ route('faqs.edit', $faq->id) }}" class="link-primary fw-medium">{{ $faq->question }}</a>
                                            </td>
                                            <td>{!! Str::limit(strip_tags($faq->answer), 80) !!}</td>
                                            <td>{{ $faq->category->name ?? 'Uncategorized' }}</td>
                                            <td>{{ $faq->created_at->format('d M Y') }}</td>
                                            <td>
                                                <div class="d-flex gap-1">
                                                    <a href="{{ route('faqs.edit', $faq->id) }}" class="btn btn-soft-primary btn-sm" title="Edit FAQ">
                                                        <iconify-icon icon="solar:pen-2-broken" class="align-middle fs-18"></iconify-icon>
                                                    </a>
                                                    <form action="{{ route('faqs.destroy', $faq->id) }}" method="POST" class="delete-faq-form">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-soft-danger btn-sm sweetalert-delete-btn" title="Delete FAQ">
                                                            <iconify-icon icon="solar:trash-bin-minimalistic-2-broken" class="align-middle fs-18"></iconify-icon>
                                                        </button>
                                                    </form>
                                                </div>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="5" class="text-center">No FAQs found.</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>

                    </div>
                </div>
                <div class="card-footer border-top">
                    <div class="d-flex justify-content-end">
                            {{ $faqs->links('pagination::bootstrap-5') }}
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>
<!-- End Container Fluid -->

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const deleteButtons = document.querySelectorAll('.sweetalert-delete-btn');

    deleteButtons.forEach(button => {
        button.addEventListener('click', function (e) {
            e.preventDefault(); // Prevent form submission
            const form = this.closest('form');

            Swal.fire({
                title: 'Are you sure?',
                text: "This FAQ will be permanently deleted!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, delete it!',
                cancelButtonText: 'Cancel',
                customClass: {
                    confirmButton: 'btn btn-primary w-xs me-2 mt-2',
                    cancelButton: 'btn btn-danger w-xs mt-2'
                },
                buttonsStyling: false
            }).then((result) => {
                if (result.isConfirmed) {
                    form.submit();
                } else {
                    Swal.fire({
                        title: 'Cancelled',
                        text: 'The FAQ was not deleted.',
                        icon: 'info',
                        confirmButtonText: 'OK',
                        customClass: {
                            confirmButton: 'btn btn-primary mt-2'
                        },
                        buttonsStyling: false
                    });
                }
            });
        });
    });
});
</script>

@endsection
