@extends('admin.admin-layout')

@section('content')
<!-- Start Container Fluid -->
<div class="container-xxl">
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif
     <div class="card">
        <div class="card-header d-flex justify-content-end align-items-center  gap-1">
            <div class="d-flex gap-2">
                <a href="{{route('All-coupons') }}" class="btn btn-sm btn-secondary">← Back</a>
            </div>
        </div>
    </div>
    <form action="{{ route('Update-coupon', $coupon->id) }}" method="POST">
        @csrf
        <div class="row">
            <div class="col-lg-5">
                <!-- Coupon Status -->
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Coupon Status</h4>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            @php $status = $coupon->status; @endphp
                            <div class="col-lg-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="status" value="active" id="status-active" {{ $status == 'active' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="status-active">Active</label>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="status" value="inactive" id="status-inactive" {{ $status == 'inactive' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="status-inactive">Inactive</label>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="status" value="future" id="status-future" {{ $status == 'future' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="status-future">Future Plan</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Date Schedule -->
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Date Schedule</h4>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="start-date" class="form-label text-dark">Start Date</label>
                            <input type="date" id="start-date" name="start_date" class="form-control" value="{{ old('start_date', $coupon->start_date->format('Y-m-d')) }}" required>
                        </div>
                        <div class="mb-3">
                            <label for="end-date" class="form-label text-dark">End Date</label>
                           <input type="date" id="end-date" name="end_date" class="form-control" value="{{ old('start_date', $coupon->end_date->format('Y-m-d')) }}" required>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Coupon Info -->
            <div class="col-lg-7">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Coupon Information</h4>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <!-- Coupon Code -->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="coupons-code" class="form-label">Coupons Code</label>
                                    <input type="text" id="coupons-code" name="code" class="form-control" value="{{ $coupon->code }}" required>
                                </div>
                            </div>
                            <!-- Coupon Limit -->
                            <div class="col-lg-6">
                            </div>
                        </div>

                        <!-- Coupon Type -->
                        <h4 class="card-title mb-3 mt-2">Coupons Types</h4>
                        @php $type = $coupon->type; @endphp
                        <div class="row mb-3">
                            <div class="col-lg-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="type" id="type-free" value="free_shipping" {{ $type == 'free_shipping' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="type-free">Free Shipping</label>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="type" id="type-percent" value="percent" {{ $type == 'percent' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="type-percent">Percentage</label>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="type" id="type-fixed" value="fixed" {{ $type == 'fixed' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="type-fixed">Fixed Amount</label>
                                </div>
                            </div>
                        </div>

                        <!-- Discount Value -->
                        <div class="row">
                            <div class="col-lg-12">
                                <label for="discount-value" class="form-label">Discount Value</label>
                                <input type="text" id="discount-value" name="value" class="form-control" value="{{ $coupon->value }}" required>
                            </div>
                        </div>
                    </div>

                    <!-- Submit -->
                    <div class="card-footer border-top">
                        <button type="submit" class="btn btn-primary">Update Coupon</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<!-- End Container Fluid -->
@endsection
