<!DOCTYPE html>
<html lang="en" class="h-100">

<head>
     <!-- Title Meta -->
     <meta charset="utf-8" />
     <title>Sign In | C3 </title>
     <meta name="viewport" content="width=device-width, initial-scale=1.0">
     <meta name="description" content="admin dashboard " />
     <meta name="author" content="C3" />
     <meta http-equiv="X-UA-Compatible" content="IE=edge" />

     <!-- App favicon -->
     <link rel="shortcut icon" href="{{ asset('assets/images/favicon.ico') }}">

     <!-- Vendor css (Require in all Page) -->
     <link href="{{ asset('assets/css/vendor.min.css') }}" rel="stylesheet" type="text/css" />

     <!-- Icons css (Require in all Page) -->
     <link href="{{ asset('assets/css/icons.min.css') }}" rel="stylesheet" type="text/css" />

     <!-- App css (Require in all Page) -->
     <link href="{{ asset('assets/css/app.min.css') }}" rel="stylesheet" type="text/css" />

     <!-- Theme Config js (Require in all Page) -->
     <script src="{{ asset('assets/js/config.js') }}"></script>
</head>

<body class="h-100">
     <div class="d-flex flex-column h-100 p-3">
          <div class="d-flex flex-column flex-grow-1">
               <div class="row h-100">
                    <div class="col-xxl-7">
                         <div class="row justify-content-center h-100">
                              <div class="col-lg-6 py-lg-5">
                                   <div class="d-flex flex-column h-100 justify-content-center">
                                        <div class="auth-logo mb-4 text-center">
                                             <a href="#" class="logo-dark">
                                                  <img src="{{ asset('images/logo.png') }}" height="50" alt="logo dark">
                                             </a>

                                             <a href="#" class="logo-light">
                                                  <img src="{{ asset('images/logo.png') }}" height="50" alt="logo light">
                                             </a>
                                        </div>
                                        @if (session('success'))
                                            <div class="alert alert-success">
                                                {{ session('success') }}
                                            </div>
                                        @endif
                                        <h2 class="fw-bold fs-24">Sign In</h2>

                                        <p class="text-muted mt-1 mb-4">Enter your email address and password to access admin panel.</p>

                                        <div class="mb-5">
                                             <form action="{{ route('admin.login.submit') }}" method="POST" class="authentication-form">
                                                    @csrf

                                                    @if (session('error'))
                                                        <div class="alert alert-danger">{{ session('error') }}</div>
                                                    @endif

                                                    @if ($errors->any())
                                                        <div class="alert alert-danger">
                                                            <ul class="mb-0">
                                                                @foreach ($errors->all() as $error)
                                                                    <li>{{ $error }}</li>
                                                                @endforeach
                                                            </ul>
                                                        </div>
                                                    @endif

                                                    <div class="mb-3">
                                                        <label class="form-label" for="email">Email</label>
                                                        <input type="email" id="email" name="email" class="form-control" placeholder="Enter your email" value="{{ old('email') }}" required>
                                                    </div>

                                                    <div class="mb-3">
                                                        <label class="form-label" for="password">Password</label>
                                                        <input type="password" id="password" name="password" class="form-control" placeholder="Enter your password" required>
                                                        <a href="#" class="float-end text-muted text-unline-dashed ms-1">Reset password</a>
                                                    </div>

                                                    <div class="mb-3">
                                                        <div class="form-check">
                                                            <input type="checkbox" class="form-check-input" id="remember" name="remember">
                                                            <label class="form-check-label" for="remember">Remember me</label>
                                                        </div>
                                                    </div>

                                                    <div class="mb-0 text-center d-grid">
                                                        <button class="btn btn-soft-primary" type="submit">Sign In</button>
                                                    </div>
                                                </form>
                                        </div>
                                        <p class=" mt-0 text-danger text-center">Don't have an account? <a href="{{route('admin.register')}}" class="text-dark fw-bold ms-1">Sign Up</a></p>
                                   </div>
                              </div>
                         </div>
                    </div>
               </div>
          </div>
     </div>

     <!-- Vendor Javascript (Require in all Page) -->
     <script src="{{ asset('assets/js/vendor.js')}}"></script>

     <!-- App Javascript (Require in all Page) -->
     <script src="{{ asset('assets/js/app.js')}}"></script>

</body>
</html>