@extends('layouts/layout')

@section('content')
<!-- Wishlist Products Section -->
<div class="wishlist-section py-5 ">
  <div class="container">

    <!-- Heading -->
    <h3 class="text-center mb-4" style="color: #652E2E !important;">Wishlist </h3>

    <!-- Wishlist Product Grid -->
    <div class="row g-4" id="wishlistProductContainer">
      @if ($products->count())
            @foreach ($products as $product)
                <div class="col-lg-3 col-md-4 col-sm-6">
                        <div class="card border-0 shadow-sm h-100">
                            <div class="position-relative">
                                    <!-- Heart Icon -->
                                    <a href="javascript:void(0);"
                                    class="position-absolute wishlist-toggle text-brown"
                                    data-product-id="{{ $product->id }}"
                                    style="top: 10px; right: 10px; z-index: 2;">
                                    <i class="fa-{{ in_array($product->id, $wishlistIds) ? 'solid' : 'regular' }} fa-heart fs-4 text-brown"></i>
                                    </a>

                                    <!-- Image -->
                                    <a href="{{ route('product.detail', $product->id) }}">
                                    <img src="{{ asset('storage/' . $product->image) }}" class="card-img-top img-fluid" alt="Product">
                                    </a>
                            </div>

                            <div class="card-body text-center">
                                    <h6 class="card-title text-truncate" style="max-width: 100%;">{{ $product->name }}</h6>
                                    <p class="price"style="color: #652E2E !important;">
                                        <del class="discount text-muted mb-1">₹ {{ number_format($product->price, 2) }}</del>
                                        <span>₹{{ number_format($product->price-$product->discount, 2) }}</span>
                                    </p>
                                    @php
                                        $quantity = $cartItems[$product->id] ?? 0;
                                    @endphp
                                    <div class="d-flex justify-content-center gap-3">
                                        @if ($quantity > 0)
                                            <!-- Show quantity selector -->
                                            <div class="d-flex justify-content-center">
                                                <div class="input-group view-product-wishlist quantity-selector  rounded" style="width: 100px; height:35px;" data-product-id="{{ $product->id }}">
                                                    <button class="btn btn-sm text-white bg-maroon qty-decrease">−</button>
                                                    <input type="text" class="form-control text-center cart-qty" value="{{ $quantity }}" readonly>
                                                    <button class="btn btn-sm text-white bg-maroon qty-increase">+</button>
                                                </div>
                                            </div>
                                        @else
                                            <!-- Show Add to Cart button -->
                                            <a href="javascript:void(0);" 
                                            class="btn view-product-wishlist add-to-cart " 
                                            data-product-id="{{ $product->id }}">
                                            Add to Cart
                                            </a>
                                        @endif
                                        <a href="javascript:void(0);" class="btn text-right  border px-4 " data-bs-toggle="offcanvas" data-bs-target="#cart-offcanvas">
                                            <i class="fa-solid fa-cart-shopping me-2 text-brown" style="font-size: 1.2rem;"></i>
                                        </a>
                                    </div>
                            </div>
                        </div>
                    </div>
            @endforeach
      @else
        <div class="col-12 text-center">
          <p class="text-muted">Your wishlist is empty.</p>
          <a href="{{ url('/') }}" class="btn view-product-wishlist mt-3">Continue Shopping</a>
        </div>
      @endif
    </div>
  </div>
</div>

<!-- ------------------------------------------------------------------------------------------------------------ -->
<!-- Script of Storing Wishlist  -------------------------------------------------------------------------------- -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function () {
  $('.wishlist-toggle').click(function () {
    let productId = $(this).data('product-id');
    let icon = $(this).find('i');

    $.ajax({
      url: "{{ route('wishlist.toggle') }}",
      type: "POST",
      data: {
        _token: '{{ csrf_token() }}',
        product_id: productId
      },
      success: function (res) {
        if (res.status === 'added') {
          icon.removeClass('fa-regular').addClass('fa-solid');
        } else if (res.status === 'removed') {
                icon.closest('.col-lg-3').remove();

                // Optional: Check if any wishlist items remain, show empty message
                if ($('#wishlistProductContainer').children('.col-lg-3').length === 0) {
                    $('#wishlistProductContainer').html(`
                    <div class="col-12 text-center">
                        <p class="text-muted">Your wishlist is empty.</p>
                        <a href="{{ url('/') }}" class="btn btn-primary mt-3">Continue Shopping</a>
                    </div>
                    `);
                }
            }
      },
      error: function (xhr) {
        if (xhr.status === 401) {
          alert('Please log in to use the wishlist.');
        }
      }
    });
  });
});
</script>
<!-- ------------------------------------------------------------------------------------------------------------ -->
<!-- End Script  Storing Wishlist  -------------------------------------------------------------------------------- -->


<!-- ------------------------------------------------------------------------------------------------------------ -->
<!--  Script for Storing Cart   -------------------------------------------------------------------------------- -->

<!-- <script>
    $(document).on('click', '.add-to-cart', function () {
        let productId = $(this).data('product-id');
        console.log("Clicked Add to Cart. Product ID:", productId);

        $.ajax({
            url: "{{ route('cart.add') }}",
            method: 'POST',
            data: {
                _token: "{{ csrf_token() }}",
                product_id: productId
            },
            success: function (res) {
                console.log("AJAX Success:", res);
                if (res.status === 'success') {
                    // Set modal message text
                    $('#successModalMessage').text('Added to cart!');

                    // Show the modal using Bootstrap 5 JS API
                    var successModal = new bootstrap.Modal(document.getElementById('successModal'));
                    successModal.show();

                } else if (res.status === 'unauthenticated') {
                    alert('Please log in to add to cart.');
                } else {
                    alert('Unexpected response.');
                }
            },
            error: function (xhr) {
                console.log("AJAX Error:", xhr.responseText);
                alert('Something went wrong!');
            }
        });
    });
</script> -->
<script>
$(document).ready(function () {

    // Add to cart
    $(document).on('click', '.add-to-cart', function () {
        let productId = $(this).data('product-id');
        let $button = $(this);

        $.ajax({
            url: "{{ route('cart.add') }}",
            method: 'POST',
            data: {
                _token: "{{ csrf_token() }}",
                product_id: productId
            },
            success: function (res) {
                if (res.status === 'success') {
                    let qtyHtml = `
                        <div class="d-flex justify-content-center">
                            <div class="input-group quantity-selector  rounded" style="width: 100px;" data-product-id="${productId}">
                                <button class="btn btn-sm text-white bg-maroon qty-decrease">−</button>
                                <input type="text" class="form-control text-center cart-qty" value="${res.quantity}" readonly>
                                <button class="btn btn-sm text-white bg-maroon qty-increase">+</button>
                            </div>
                        </div>
                    `;
                    $button.replaceWith(qtyHtml);

                     // Show success message and "Go to Cart" button
                        document.getElementById('successModalLabel').innerText = '';
                        document.getElementById('successModalMessage').innerText = res.message;
                        document.getElementById('modalActionButton').classList.remove('d-none');

                        const modal = new bootstrap.Modal(document.getElementById('successModal'));
                        modal.show();
                } else if (res.status === 'unauthenticated') {
                    alert('Please log in to add to cart.');
                }
            },
            error: function () {
                alert('Something went wrong!');
            }
        });
    });

    // Increase quantity
    $(document).on('click', '.qty-increase', function () {
        let $selector = $(this).closest('.quantity-selector');
        let productId = $selector.data('product-id');
        let $qtyInput = $selector.find('.cart-qty');
        let qty = parseInt($qtyInput.val()) + 1;

        $.ajax({
            url: "{{ route('cart.update') }}",
            method: 'POST',
            data: {
                _token: "{{ csrf_token() }}",
                product_id: productId,
                quantity: qty
            },
            success: function (res) {
                if (res.status === 'success') {
                    $qtyInput.val(res.quantity);
                    showSuccessModal(res.message);
                }
            }
        });
    });

    // Decrease quantity
    $(document).on('click', '.qty-decrease', function () {
        let $selector = $(this).closest('.quantity-selector');
        let productId = $selector.data('product-id');
        let $qtyInput = $selector.find('.cart-qty');
        let qty = parseInt($qtyInput.val());

        if (qty <= 1) {
            // Remove from cart
            $.ajax({
                url: "{{ route('cart.remove') }}",
                method: 'POST',
                data: {
                    _token: "{{ csrf_token() }}",
                    product_id: productId
                },
                success: function (res) {
                    if (res.status === 'success') {
                        let addBtn = `
                            <a href="javascript:void(0);"
                               class="btn  view-product-wishlist add-to-cart" 
                               data-product-id="${productId}">
                               Add to Cart
                            </a>
                        `;
                        $selector.replaceWith(addBtn);

                        showSuccessModal(res.message);
                    }
                }
            });
        } else {
            qty -= 1;

            $.ajax({
                url: "{{ route('cart.update') }}",
                method: 'POST',
                data: {
                    _token: "{{ csrf_token() }}",
                    product_id: productId,
                    quantity: qty
                },
                success: function (res) {
                    if (res.status === 'success') {
                        $qtyInput.val(res.quantity);
                        showSuccessModal(res.message);
                    }
                }
            });
        }
    });

    // 🔔 Reusable success modal function
    function showSuccessModal(message) {
        $('#successModalMessage').text(message);
        var modal = new bootstrap.Modal(document.getElementById('successModal'));
        modal.show();
    }
});
</script>
<script>
  document.addEventListener('DOMContentLoaded', function () {
    const goToCartBtn = document.getElementById('goToCartBtn');
    if (goToCartBtn) {
        goToCartBtn.addEventListener('click', function (e) {
            e.preventDefault(); // prevent immediate navigation
            const modal = bootstrap.Modal.getInstance(document.getElementById('successModal'));
            modal.hide(); // close modal

            // Navigate after a short delay
            setTimeout(() => {
                window.location.href = this.href;
            }, 300); // adjust delay if needed
        });
    }
  });
</script>
@endsection
