@extends('layouts/layout')

@section('content')


<div class="container-fluid mt-4 p-4">
  <div class="row">
    <!-- Sidebar -->
    <div class="col-md-3 sidebar-profile">
      <h6>Account</h6>
      <a href="#" class="tab-link active" data-target="profile-section">Profile</a>
      <a href="#" class="tab-link" data-target="saved-address-section">Saved Addresses</a>

      <div class="profile-side-divider"></div>

      <h6 class="mt-4">Orders</h6>
      <a href="#" class="tab-link" data-target="order-section">Orders & Returns</a>

      <div class="profile-side-divider"></div>

      <h6 class="mt-4">Credits</h6>
      <a href="#" class="tab-link" data-target="coupon-section">Coupons</a>

      <div class="profile-side-divider"></div>

      <h6 class="mt-4">Legal</h6>
      <a href="#" class="tab-link" data-target="T&C-section">T&C</a>
      <a href="#" class="tab-link" data-target="Policy-section">Privacy Policy</a>
      <div class="profile-side-divider"></div>
    </div>

    <!-- Content Section -->
    <div class="col-md-9 p-4">
      <!-- Profile Section -->
      <div class="form-box tab-content active" id="profile-section">
        <form method="POST" action="{{ route('user.profile.update') }}">
          @csrf
          <div class="row mb-3">
            <div class="col-md-6">
              <label class="form-label">Mobile Number</label>
              <input type="text" name="mobile" class="form-control" value="{{ old('mobile', $user->mobile) }}" pattern="^\d{10}$" maxlength="10">
            </div>
            <div class="col-md-6">
              <label class="form-label">Full Name</label>
              <input type="text" name="name" class="form-control" value="{{ old('name', $user->name) }}">
            </div>
          </div>

          <div class="row mb-3">
            <div class="col-md-6">
              <label class="form-label">Email</label>
              <input type="email" name="email" class="form-control" value="{{ old('email', $user->email) }}">
            </div>
            <div class="col-md-6">
              <label class="form-label">Birthday (dd/mm/yyyy)</label>
              <input type="text" name="dob" class="form-control" value="{{ old('dob', $user->dob) }}">
            </div>
          </div>

          <div class="section-divider"></div>

          <p class="mb-3 fw-semibold" style="color: #3b1c1c;">Alternate mobile details</p>

          <div class="row mb-3">
            <div class="col-md-6">
              <label class="form-label">Full Name</label>
              <input type="text" name="alt_name" class="form-control" value="{{ old('alt_name', $user->alt_name) }}">
            </div>
            <div class="col-md-6">
              <label class="form-label">Mobile Number</label>
              <input type="text" name="alt_mobile" class="form-control" value="{{ old('alt_mobile', $user->alt_mobile) }}" pattern="^\d{10}$" maxlength="10">
            </div>
          </div>

          <button type="submit" class="btn btn-save-profile-detail w-100 mt-3">Save Details</button>
        </form>
      </div>

      <!-- Saved Address Section -->
      <div class="form-box tab-content d-none" id="saved-address-section">
        <div class="d-flex justify-content-between mb-3">
          <h5 class="fw-bold" style="color:#652E2E;">Saved Addresses</h5>
          <button class="btn btn-save-profile-detail" data-bs-toggle="modal" data-bs-target="#addAddressModal" onclick="prepareAddModal()">+ Add Address</button>
        </div>

          {{-- Default Address --}}
          @if($defaultAddress)
            <h6 class="mb-2 fw-bold" style="color:#652E2E;">Default Address</h6>
            <div class="address-box">
              <span class="badge">{{ ucfirst($defaultAddress->address_type) }}</span>
              <p><strong>{{ $defaultAddress->full_name }}</strong></p>
              <p>{{ $defaultAddress->address }}</p>
              <p>{{ $defaultAddress->city }} - {{ $defaultAddress->pincode }}</p>
              <p>{{ $defaultAddress->state }}</p>
              <p>Mobile : {{ $defaultAddress->mobile }}</p>

              
            </div>
          @endif

          {{-- Other Addresses --}}
          @if($otherAddresses->count())
            <h6 class="mb-2 fw-bold" style="color:#652E2E;">Other Addresses</h6>
            @foreach($otherAddresses as $address)
              <div class="address-box">
                <span class="badge">{{ ucfirst($address->address_type) }}</span>
                <p><strong>{{ $address->full_name }}</strong></p>
                <p>{{ $address->address }}</p>
                <p>{{ $address->city }} - {{ $address->pincode }}</p>
                <p>{{ $address->state }}</p>
                <p>Mobile : {{ $address->mobile }}</p>

                <form action="{{ route('user.address.make-default', $address->id) }}" method="POST">
                  @csrf
                  <small class="text-danger d-block mt-2">
                    <button type="submit" style="border:none; background:none; color:#652E2E; padding:0; font-weight:bold;">Make this default address</button>
                  </small>
                </form>

                <div class="address-actions">
                  <button
                      type="button"
                      class="btn-edit fw-bold"
                      data-id="{{ $address->id }}"
                      data-full_name="{{ e($address->full_name) }}"
                      data-mobile="{{ e($address->mobile) }}"
                      data-pincode="{{ e($address->pincode) }}"
                      data-state="{{ e($address->state) }}"
                      data-address="{{ e($address->address) }}"
                      data-locality="{{ e($address->locality) }}"
                      data-city="{{ e($address->city) }}"
                      data-address_type="{{ e($address->address_type) }}"
                      data-weekend_open='@json($address->weekend_open ?? [])'
                      data-default="{{ $address->is_default }}"
                      data-bs-toggle="modal"
                      data-bs-target="#addAddressModal"
                    >
                      Edit
                    </button>

                  <form action="{{ route('user.address.delete', $address->id) }}" method="POST" style="display:inline;">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn-remove fw-bold">Remove</button>
                  </form>
                </div>
              </div>
            @endforeach
          @endif
      </div>
      

      <div class="form-box tab-content d-none" id="order-section">
            <div class="d-flex justify-content-between mb-3">
                <h5 class="fw-bold" style="color:#652E2E;">All Order's</h5>
            </div>

            @foreach($orders as $order)
                <div class="order-card {{ strtolower($order->shipping_status) === 'delivered' ? 'inactive' : '' }}">
                    <div class="status {{ strtolower($order->shipping_status) === 'delivered' ? 'delivered' : strtolower($order->shipping_status) }}">
                        {{ ucfirst($order->shipping_status) }}
                    </div>
                    <div class="order-date">
                        On {{ \Carbon\Carbon::parse($order->created_at)->format('D, d M Y') }}
                    </div>
                    <div class="order-side-divider mt-2 mb-2"></div>

                    @foreach($order->items as $item)
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <div class="d-flex align-items-center">
                                @php
                                    $productImage = $item->product->images->first()->image ?? $item->product->image ?? 'no-image.jpg';
                                @endphp
                                <img src="{{ asset('storage/' . $productImage) }}" class="product-img me-3" alt="Product">
                                <div class="product-info">
                                    <div class="brand">{{ $item->product->brand ?? 'Brand' }}</div>
                                    <div>{{ $item->product->name ?? 'Product Title' }}</div>
                                    <div>Size : {{ $item->product_size ?? 'N/A' }}</div>
                                    <div>Qty: {{ $item->quantity }}</div>
                                    <div>Price: ₹{{ number_format($item->order_price, 2) }}</div>
                                </div>
                            </div>

                            <a href="#" class="order-right-arrow tab-link" 
                                data-product_id="{{ $item->product->id }}"
                                data-target="order-details"
                                data-brand="{{ $item->product->brand }}"
                                data-name="{{ $item->product->name }}"
                                data-size="{{ $item->product_size }}"
                                data-price="{{ $item->order_price }}"
                                data-image="{{ asset('storage/' . $productImage) }}"
                                data-status="{{ ucfirst($order->shipping_status) }}"
                                data-date="{{ \Carbon\Carbon::parse($order->created_at)->format('D, d M') }}"
                                data-address="{{ $order->address . ' ' . $order->apartment . ' ' . $order->city ?? 'Address N/A' }}"
                                data-recipient="{{ $order->first_name . ' ' . $order->last_name ?? 'Recipient' }} | {{ $order->phone ?? 'Phone' }}"
                            >›</a>
                        </div>
                    @endforeach
                    @if ($order->coupon_applied && $order->coupon)
                        <div class="text-end text-success pe-3 pb-2">
                            <strong>Coupon Applied:</strong>
                            <span class="badge bg-success-subtle text-success ms-1">{{ $order->coupon->code }}</span><i class="fa-duotone fa-solid fa-circle-check"></i>
                        </div>
                        <div class="text-end text-muted pe-3 pb-2">
                            <strong>Coupon Amount:</strong>
                            <span>
                                @if($order->coupon->type === 'percentage')
                                    {{ $order->coupon->value }}%
                                @else
                                    ₹{{ number_format($order->coupon->value, 2) }}
                                @endif
                            </span>
                        </div>
                    @endif


                    <div class="d-flex justify-content-between align-items-center px-3 pb-2">
                        <form class="cancel-order-form" action="{{ route('order.cancel', $order->id) }}" data-order-id="{{ $order->id }}" method="POST" >
                            @csrf
                            @method('POST')
                            @if(strtolower($order->shipping_status) !== 'cancelled' && strtolower($order->shipping_status) !== 'delivered')
                                <button type="submit" class="btn btn-sm btn-outline-danger">Cancel Order</button>
                            @endif
                        </form>

                        <div class="text-end">
                            <strong>Total: ₹{{ number_format($order->total, 2) }}</strong>
                        </div>
                    </div>
                </div>
            @endforeach
      </div>

        <div class="form-box tab-content d-none" id="order-details">
            <div class="card p-4">
                <div class="text-center">
                    <img id="details-image" src="https://via.placeholder.com/120x150" class="mb-3 details-image" alt="Product">
                    <div id="details-brand" class="fw-bold"></div>
                    <div id="details-name"></div>
                    <div id="details-size"></div>
                    <div id="details-price" class="fw-semibold mt-1"></div>
                </div>

                <div class="d-flex justify-content-between align-items-center bg-light p-3 mt-4 rounded">
                    <!-- Left side: Delivery Status -->
                    <div>
                      <div id="details-status" class="fw-semibold text-muted">
                        <i class="fa-solid fa-box"></i> 
                      </div>
                      <div id="details-date" class="text-muted"></div>
                    </div>

                    <!-- Right side: Rate this product -->
                    <div id="rating-section" class="text-end d-none">
                      <div class="text-muted fw-semibold">Rate this product</div>
                        <form id="submit-review-form">
                            @csrf
                            <input type="hidden" name="product_id" value="">
                            <input type="hidden" name="rating" id="rating" value="0">

                            <div class="rating-stars text-warning " id="rating-stars">
                                @for ($i = 1; $i <= 5; $i++)
                                    <span class="star" data-value="{{ $i }}" style="cursor:pointer;">
                                        <i class="fa-regular fa-star fa-xl"></i>
                                    </span>
                                @endfor
                            </div>
                        </form>
                    </div>
                  </div>


                <div class="bg-light p-3 mt-3 rounded">
                    <div class="fw-semibold mb-2"><i class="fa-solid fa-truck"></i> Delivery Address</div>
                    <div id="details-recipient"></div>
                    <div id="details-address"></div>
                </div>
                
                <button class="btn btn-link " onclick="showOrderList()">‹ Back</button>
            </div>
          </div>

          <!-- Coupon Section -->
         <div class="form-box tab-content d-none" id="coupon-section">
              <div class="col-md-10">
                  <div class="d-flex align-items-center mb-3">
                      <span class="me-2 fw-semibold">Sort by :</span>
                      <button class="sort-btn active me-2" data-sort="trending">Trending</button>
                      <button class="sort-btn me-2" data-sort="all">All</button>
                      <button class="sort-btn" data-sort="expiring">Expiring</button>
                  </div>

                  <div class="row g-1 mb-3" id="coupon-list">
                      @foreach ($coupons->chunk(2) as $couponChunk)
                          <div class="row g-1 mb-3">
                              @foreach ($couponChunk as $coupon)
                                  <div class="col-md-6">
                                      <div class="coupon-box"
                                          data-end="{{ $coupon->end_date }}"
                                          data-value="{{ $coupon->value }}"
                                          data-type="{{ $coupon->type }}">

                                          <div class="fw-bold mb-1">
                                              {{ $coupon->type == 'fixed' ? 'Flat ₹' . $coupon->value : $coupon->value . '% Off' }}
                                          </div>

                                          <!-- Code + Expiry Row -->
                                          <div class="d-flex justify-content-between align-items-center">
                                              <div class="coupon-code">
                                                  Code: <span class="code-text">{{ $coupon->code }}</span>
                                                  <i class="fa fa-copy clipboard-icon ms-1" data-code="{{ $coupon->code }}" style="cursor:pointer;"></i>
                                              </div>
                                              <div class="expiry-text">
                                                  Expiry: {{ \Carbon\Carbon::parse($coupon->end_date)->format('d/m/y') }}
                                              </div>
                                          </div>

                                      </div>
                                  </div>
                              @endforeach
                          </div>
                      @endforeach
                  </div>
              </div>
          </div>

          <div class="form-box tab-content d-none" id="T&C-section">
                {!! $terms->content ?? 'Data Not Found' !!}
          </div>

          <div class="form-box tab-content d-none" id="Policy-section">
                {!! $policy->content ?? 'Data Not Found' !!}
          </div>
      </div>
      
  </div>
</div>
<!-- Add New address popup -->

<!-- Add Address Modal -->
<div class="modal fade" id="addAddressModal" tabindex="-1" aria-labelledby="addAddressModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content p-4 rounded-4" style=" width: 100%; max-width: 500px; border: none;">

      <div class="d-flex justify-content-between align-items-center mb-3">
        <h5 class="mb-0" style="color: #3b1c1c;">Add New Address</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
        <form id="addressForm" method="POST">
          @csrf
          <input type="hidden" id="formMethod" name="_method" value="POST">

          <div class="mb-3">
            <label class="form-label">Full Name</label>
            <input type="text" name="full_name" id="full_name" class="form-control @error('full_name') is-invalid @enderror" value="{{ old('full_name') }}" required>
            @error('full_name')
              <div class="invalid-feedback">{{ $message }}</div>
            @enderror
          </div>

          <div class="mb-3">
            <label class="form-label">Mobile</label>
            <input type="text" name="mobile" id="mobile" class="form-control @error('mobile') is-invalid @enderror" value="{{ old('mobile') }}"pattern="^\d{10}$" maxlength="10" required>
            @error('mobile')
              <div class="invalid-feedback">{{ $message }}</div>
            @enderror
          </div>

          <div class="row">
            <div class="col-6 mb-3">
              <label class="form-label">Pincode</label>
              <input type="text" name="pincode" id="pincode" class="form-control @error('pincode') is-invalid @enderror" value="{{ old('pincode') }}" pattern="^\d{6}$" maxlength="6" required>
              @error('pincode')
                <div class="invalid-feedback">{{ $message }}</div>
              @enderror
            </div>
            <div class="col-6 mb-3">
              <label class="form-label">State</label>
              <input type="text" name="state" id="state" class="form-control @error('state') is-invalid @enderror" value="{{ old('state') }}" required>
              @error('state')
                <div class="invalid-feedback">{{ $message }}</div>
              @enderror
            </div>
          </div>

          <div class="mb-3">
            <label class="form-label">Address (House No, Building, Street Area)</label>
            <input type="text" name="address" id="address" class="form-control @error('address') is-invalid @enderror" value="{{ old('address') }}" required>
            @error('address')
              <div class="invalid-feedback">{{ $message }}</div>
            @enderror
          </div>

          <div class="mb-3">
            <label class="form-label">Locality / Town</label>
            <input type="text" name="locality" id="locality" class="form-control @error('locality') is-invalid @enderror" value="{{ old('locality') }}" required>
            @error('locality')
              <div class="invalid-feedback">{{ $message }}</div>
            @enderror
          </div>

          <div class="mb-3">
            <label class="form-label">City / District</label>
            <input type="text" name="city" id="city" class="form-control @error('city') is-invalid @enderror" value="{{ old('city') }}" required>
            @error('city')
              <div class="invalid-feedback">{{ $message }}</div>
            @enderror
          </div>

          <div class="mb-3">
            <label class="form-label d-block">Type of Address</label>
            <div class="form-check form-check-inline">
              <input class="form-check-input" type="radio" name="address_type" value="home" id="homeRadio" {{ old('address_type', 'home') == 'home' ? 'checked' : '' }}>
              <label class="form-check-label" for="homeRadio">Home</label>
            </div>
            <div class="form-check form-check-inline">
              <input class="form-check-input" type="radio" name="address_type" value="office" id="officeRadio" {{ old('address_type') == 'office' ? 'checked' : '' }}>
              <label class="form-check-label" for="officeRadio">Office</label>
            </div>
            @error('address_type')
              <div class="text-danger mt-1">{{ $message }}</div>
            @enderror
          </div>

          <div class="mb-2">
            <label class="form-label">Is your office open on weekends?</label>
            <div class="form-check">
              <input class="form-check-input" type="checkbox" name="weekend_open[]" value="saturday" id="saturdayCheck" {{ is_array(old('weekend_open')) && in_array('saturday', old('weekend_open')) ? 'checked' : '' }}>
              <label class="form-check-label" for="saturdayCheck">Open on Saturday</label>
            </div>
            <div class="form-check">
              <input class="form-check-input" type="checkbox" name="weekend_open[]" value="sunday" id="sundayCheck" {{ is_array(old('weekend_open')) && in_array('sunday', old('weekend_open')) ? 'checked' : '' }}>
              <label class="form-check-label" for="sundayCheck">Open on Sunday</label>
            </div>
          </div>

          <hr>

          <div class="form-check mb-3">
            <input class="form-check-input" type="checkbox" name="default_address" value="1" id="defaultAddress" {{ old('default_address') ? 'checked' : '' }}>
            <label class="form-check-label" for="defaultAddress">Make this as my default address</label>
          </div>

          <div class="d-flex justify-content-between">
            <button type="button" class="btn btn-outline-secondary px-4" data-bs-dismiss="modal">Cancel</button>
            <button type="submit" class="btn" style="background-color: #652E2E; color: white; min-width: 100px;">Save</button>
          </div>
        </form>

    </div>
  </div>
</div>

<!-- ------------------- -->

<!-- ------------------------------------------------------------------------------------------------------------------- -->
<!-- ----------------------------------------------------------------------------------------------------------------- -->
<script>
  const links = document.querySelectorAll('.tab-link');
  const sections = document.querySelectorAll('.tab-content');

  links.forEach(link => {
    link.addEventListener('click', function (e) {
      e.preventDefault();
      links.forEach(l => l.classList.remove('active'));
      this.classList.add('active');

      const target = this.getAttribute('data-target');

      sections.forEach(section => {
        if (section.id === target) {
          section.classList.remove('d-none');
          section.classList.add('active');
        } else {
          section.classList.add('d-none');
          section.classList.remove('active');
        }
      });
    });
  });
</script>
<script>
  document.querySelectorAll('.btn-edit').forEach(button => {
    button.addEventListener('click', function () {
      const modal = new bootstrap.Modal(document.getElementById('addAddressModal'));

      // Fill form
      document.getElementById('full_name').value = this.dataset.full_name;
      document.getElementById('mobile').value = this.dataset.mobile;
      document.getElementById('pincode').value = this.dataset.pincode;
      document.getElementById('state').value = this.dataset.state;
      document.getElementById('address').value = this.dataset.address;
      document.getElementById('locality').value = this.dataset.locality;
      document.getElementById('city').value = this.dataset.city;

      // Address Type
      if (this.dataset.address_type === 'home') {
        document.getElementById('homeRadio').checked = true;
      } else {
        document.getElementById('officeRadio').checked = true;
      }

      // Weekend checkboxes
      const weekendOpen = JSON.parse(this.dataset.weekend_open || "[]");
      document.getElementById('saturdayCheck').checked = weekendOpen.includes('saturday');
      document.getElementById('sundayCheck').checked = weekendOpen.includes('sunday');

      // Default checkbox
      document.getElementById('defaultAddress').checked = this.dataset.default == 1;

      // Set form action and method
      const form = document.getElementById('addressForm');
      form.action = `/user/address/update/${this.dataset.id}`;
      document.getElementById('formMethod').value = 'POST';

      // Update modal title and button
      document.querySelector('#addAddressModal h5').innerText = 'Edit Address';
      document.querySelector('#addAddressModal button[type="submit"]').innerText = 'Update';

      modal.show();
    });
  });
</script>
<script>
  function prepareAddModal() {
    const form = document.getElementById('addressForm');
    form.reset();
    form.action = "{{ route('user.address.store') }}";
    document.getElementById('formMethod').value = 'POST';
    document.querySelector('#addAddressModal h5').innerText = 'Add New Address';
    document.querySelector('#addAddressModal button[type="submit"]').innerText = 'Save';
  }
</script>
<script>
  const addAddressModal = document.getElementById('addAddressModal');
  addAddressModal.addEventListener('hidden.bs.modal', function () {
    // Remove the backdrop manually
    document.querySelector('.modal-backdrop').remove();
    // Ensure the body doesn't retain modal-related styles
    document.body.classList.remove('modal-open');
    document.body.style.overflow = ''; // Restore scrolling
  });
</script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const arrows = document.querySelectorAll('.order-right-arrow');

    arrows.forEach(arrow => {
        arrow.addEventListener('click', function (e) {
            e.preventDefault();

            // Get data attributes
            const product_id = this.dataset.product_id;
            const image = this.dataset.image;
            const brand = this.dataset.brand;
            const name = this.dataset.name;
            const size = this.dataset.size;
            const price = this.dataset.price;
            const status = this.dataset.status;
            const date = this.dataset.date;
            const address = this.dataset.address;
            const recipient = this.dataset.recipient;

            // Populate details section
            document.querySelector('#submit-review-form input[name="product_id"]').value = product_id;
            document.getElementById('details-image').src = image;
            document.getElementById('details-brand').textContent = brand;
            document.getElementById('details-name').textContent = name;
            document.getElementById('details-size').textContent = "Size : " + size;
            document.getElementById('details-price').textContent = "₹ " + price;
            document.getElementById('details-status').innerHTML = `<i class="fa-solid fa-box"></i> ${status}`;
            document.getElementById('details-date').textContent = "On " + date;
            document.getElementById('details-address').textContent = address;
            document.getElementById('details-recipient').textContent = recipient;

            const ratingSection = document.getElementById('rating-section');
            if (status.toLowerCase() === 'delivered') {
                ratingSection.classList.remove('d-none');
            } else {
                ratingSection.classList.add('d-none');
            }

            // Toggle visibility
            document.getElementById('order-section').classList.add('d-none');
            document.getElementById('order-details').classList.remove('d-none');
        });
    });
});
</script>
<script>
function showOrderList() {
    document.getElementById('order-details').classList.add('d-none');
    document.getElementById('order-section').classList.remove('d-none');
}
</script>

<script>
document.addEventListener("DOMContentLoaded", function () {
    const stars = document.querySelectorAll("#rating-stars .star");
    const ratingInput = document.getElementById("rating");
    const form = document.getElementById("submit-review-form");

    stars.forEach(star => {
        star.addEventListener("click", function () {
            const rating = this.getAttribute("data-value");
            ratingInput.value = rating;

            // Highlight selected stars
            stars.forEach(s => {
                const val = s.getAttribute("data-value");
                const icon = s.querySelector("i");
                if (val <= rating) {
                    icon.classList.remove("fa-regular");
                    icon.classList.add("fa-solid");
                } else {
                    icon.classList.remove("fa-solid");
                    icon.classList.add("fa-regular");
                }
            });

            // Trigger AJAX submit
            const formData = new FormData(form);
            fetch("{{ route('product.review') }}", {
                method: "POST",
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('input[name="_token"]').value,
                    'Accept': 'application/json'
                },
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success || data.status === 'success') {
                    alert(data.message || "Thanks for your feedback!");
                } else {
                    alert(data.message || "Something went wrong!");
                }
            })
            .catch(error => {
                console.error("Error:", error);
                alert("Error submitting review.");
            });
        });
    });
});
</script>
<script>
    // Copy to clipboard & show success modal
    document.querySelectorAll('.clipboard-icon').forEach(function(icon) {
        icon.addEventListener('click', function () {
            const code = this.getAttribute('data-code');

            navigator.clipboard.writeText(code).then(() => {
                // Set modal content
                document.getElementById('successModalLabel').innerText = "Coupon Code Copied!";
                document.getElementById('successModalMessage').innerText = `"${code}" has been copied to your clipboard.`;

                // Show the modal using Bootstrap 5
                const successModal = new bootstrap.Modal(document.getElementById('successModal'));
                successModal.show();
            });
        });
    });

    // Filter logic (optional basic demo)
    document.querySelectorAll('.sort-btn').forEach(function(btn) {
        btn.addEventListener('click', function() {
            const sortType = this.getAttribute('data-sort');

            document.querySelectorAll('.sort-btn').forEach(b => b.classList.remove('active'));
            this.classList.add('active');

            const today = new Date();

            document.querySelectorAll('.coupon-box').forEach(function(box) {
                const endDate = new Date(box.getAttribute('data-end'));

                if (sortType === 'expiring') {
                    // Show only coupons expiring in next 7 days
                    const diffDays = (endDate - today) / (1000 * 60 * 60 * 24);
                    box.closest('.col-md-6').style.display = (diffDays <= 7 && diffDays >= 0) ? 'block' : 'none';
                } else {
                    box.closest('.col-md-6').style.display = 'block'; // Show all
                }
            });
        });
    });
</script>

<script>
document.querySelectorAll('.cancel-order-form').forEach(form => {
    form.addEventListener('submit', function(e) {
        e.preventDefault(); // prevent default form submit

        Swal.fire({
            title: 'Are you sure?',
            text: "You are about to cancel this order.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, cancel it!',
            cancelButtonText: 'No, keep it'
        }).then((result) => {
            if (result.isConfirmed) {
                form.submit(); // proceed with form submit
            }
        });
    });
});
</script>


@endsection
<style>
      .order-card {
      background-color: white;
      border-radius: 12px;
      padding: 1rem;
      margin-bottom: 1.2rem;
      box-shadow: 0 0 2px rgba(0, 0, 0, 0.05);
    }

    .order-card hr {
      margin: 10px 0;
      color: #eee;
    }

    .status {
      font-weight: bold;
      font-size: 14px;
    }

    .status.pending {
  color: #FFA500; /* Orange */
}

.status.processing {
  color: #007BFF; /* Blue */
}

 .status.return {
      color:rgb(251, 0, 0);
    }

    .status.dispatched {
      color: #24B200;
    }

    .status.delivered {
      color: gray;
    }

    .order-date {
      font-size: 14px;
      color: #666;
    }

    .product-img {
      width: 50px;
      height: 70px;
      object-fit: contain;
      border-radius: 8px;
    }

    .product-info {
      font-size: 14px;
    }

    .product-info .brand {
      font-weight: 600;
      color: #000;
    }

    .order-right-arrow {
      font-size: 20px;
      color: #333;
      text-decoration: none !important;
    }

.order-side-divider{
      border-top: 1px solid #D8D8D8;
    }

     .details-image {
      width: 150px !important;
      height: 170px !important;
      object-fit: fill !important;
      border-radius: 12px !important;
    }
.rating-stars i {
  font-size: 0.9rem;
  cursor: pointer;
  transition: color 0.2s;
}

.rating-stars i:hover,
.rating-stars i.hovered,
.rating-stars i.selected {
  color: #ffc107; /* Bootstrap warning color */
}
/* Coupon Section STyling CSS */
.coupon-box {
      background-color: #fff;
      padding: 16px;
      border-radius: 8px;
      border: 1px solid #f7f2f2;
      box-shadow: 0 0 5px rgba(0, 0, 0, 0.02);
      margin-right:25px;
    }

    .coupon-code {
      font-weight: 600;
      font-size: 14px;
    }

    .expiry-text {
      color: #e3342f;
      font-size: 13px;
      font-weight: 500;
    }

    .sort-btn {
      font-size: 13px;
      padding: 6px 14px;
      border-radius: 999px;
      border: none;
    }

    .sort-btn.active {
      background-color: #F4C2C2;
      color: #000;
    }

    .sort-btn:not(.active) {
      background-color: #fff;
      border: 1px solid #ddd;
      color: #444;
    }

    .clipboard-icon {
      cursor: pointer;
      margin-left: 6px;
      font-size: 13px;
      color: #555;
    }
</style>
