@extends('layouts/layout')

@section('content')
<div class="container py-2"    style="background-color: #FFF6EA;">
    <div class="row">
        <!-- Product Image Thumbnails (Grid - Left Side) -->
        <div class="col-lg-8 image-scroll-wrapper">
            <div class="row">
                @php 
                    $images = $product->images->groupBy('color_id'); 
                @endphp

                @foreach ($images as $colorId => $colorImages)
                    <div class="image-group" data-color-id="{{ $colorId }}">
                        <div class="row">
                            @foreach ($colorImages->chunk(2) as $chunk)
                                <div class="row mb-3 align-items-center ">
                                    @foreach ($chunk as $img)
                                        <div class="col-md-6 col-sm-6 mb-3">
                                            <img src="{{ asset('storage/' . $img->image_path) }}"
                                                class="img-fluid rounded shadow-sm w-100 preview-image"
                                                alt="Product Image"
                                                data-bs-toggle="modal"
                                                data-bs-target="#imagePreviewModal"
                                                data-img="{{ asset('storage/' . $img->image_path) }}"
                                                data-index="{{ $loop->parent->parent->index * 2 + $loop->index }}">
                                        </div>
                                    @endforeach
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
        <!-- Modal for Preview -->
        <div class="modal fade" id="imagePreviewModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-sm">
            <div class="modal-content bg-transparent border-0 position-relative" style="position: relative;">

            <!-- Close Button -->
            <button type="button"
                    class="btn-close position-absolute top-0 end-0 m-2"
                    data-bs-dismiss="modal"
                    aria-label="Close"
                    style="z-index: 1051;"></button>

            <!-- Image -->
            <div class="modal-body text-center p-0">
                <img id="previewModalImage" src="" class="img-fluid zoomable rounded" alt="Product Preview" style="z-index: 1;">
            </div>

            <!-- Navigation Arrows -->
            <button class="btn position-absolute top-50 start-0 translate-middle-y bg-white shadow prev-img"
                    style="z-index: 1051;">❮</button>
            <button class="btn position-absolute top-50 end-0 translate-middle-y bg-white shadow next-img"
                    style="z-index: 1051;">❯</button>

            </div>
        </div>
        </div>

        <div class="col-lg-4 sticky-description mt-1">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><strong>{{ $product->name }}</strong></h5>
                     <!-- <a href="javascript:void(0);" 
                        class="heart-icon wishlist-toggle" 
                        data-product-id="{{ $product->id }}"
                        style="top: 10px; right: 10px; z-index: 2;">
                        <i class="fa-{{ in_array($product->id, $wishlistIds) ? 'solid' : 'regular' }} fa-heart fs-4 text-brown"></i>
                      </a> -->
            </div>
           <p class="mb-1 mt-1" >
                <span class="text-muted text-decoration-line-through me-1">Rs. {{ number_format($product->price, 2) }}</span>
                <span class="fw-bold text-brown">Rs. {{ number_format($product->price - $product->discount, 2) }}</span>
                <span class="badge save-price">Save Rs.{{ number_format($product->discount, 2) }}</span>
            </p>
            @php
                $groupedImagesByColor = $product->images->groupBy('color_id');
            @endphp
            <div class="mb-2">
                <div class="d-flex gap-2 flex-wrap color-image-options">
                    @foreach ($groupedImagesByColor as $colorId => $images)
                        @php
                            $color = $colors->firstWhere('id', $colorId);
                            $firstImage = $images->first();
                        @endphp

                        <input type="radio"
                            name="color"
                            id="color-{{ $colorId }}"
                            value="{{ $colorId }}"
                            class="btn-check color-radio"
                            autocomplete="off"
                            @if ($loop->first) checked @endif>

                        <label for="color-{{ $colorId }}"
                            class="color-label  rounded overflow-hidden"
                            data-color-name="{{ $color->color_name ?? '' }}">
                            <img src="{{ asset('storage/' . $firstImage->image_path) }}"
                                alt="{{ $color->color_name ?? 'Color' }}"
                                class="img-fluid"
                                style="height: 70px; width: 60px; object-fit: fill;">
                        </label>
                    @endforeach
                </div>
            </div>
            <strong>Color: <span id="selected-color-name">{{ $colors->first()->color_name ?? '' }}</span></strong>

            <div class="size-box ">

            <Strong>Size : <span id="selected-size"></span></Strong><br>
                    @php
                        $sizes = explode(',', $product->size);
                    @endphp

                    @foreach ($sizes as $size)
                        <input type="radio" name="size" id="size{{ $size }}" value="{{ $size }}">
                        <label for="size{{ $size }}">{{ $size }}</label>
                    @endforeach
                </div>
                <p class="text-muted" style="font-size: 0.85rem;">Estimated delivery between 03 June - 09 June.</p>
                @php
                    $quantity = $cartItems[$product->id] ?? 0;
                @endphp
                <div class="d-flex  gap-1">
                    @if ($quantity > 0)
                        <!-- Show quantity selector -->
                        <div class="d-flex justify-content-center">
                            <div class="input-group view-product-wishlist quantity-selector  rounded" style="width: 100px; height:35px;" data-product-id="{{ $product->id }}">
                                <button class="btn  text-white bg-maroon qty-decrease">−</button>
                                <input type="text" class="form-control text-center cart-qty" value="{{ $quantity }}" readonly>
                                <button class="btn  text-white bg-maroon qty-increase">+</button>
                            </div>
                        </div>

                    @else
                        <!-- Show Add to Cart button -->
                        <a href="javascript:void(0);" 
                        class="btn cart-button-product-detail add-to-cart col-md-4" style="white-space: nowrap;" 
                        data-product-id="{{ $product->id }}"
                        data-color=""
                        data-size="">
                        Add to Cart
                        </a>
                    @endif
                    <!-- Share Button -->
                    <button class="btn  share-btn btn-outline-secondary col-md-4" style="width: 115px; height:35px;" onclick="shareCurrentPage('{{ $product->name }}')">
                        <i class="fa-solid fa-share-nodes"></i>
                    </button>
                    <a href="javascript:void(0);" class="btn  px-4 " data-bs-toggle="offcanvas" data-bs-target="#cart-offcanvas">
                        <i class="fa-solid fa-cart-shopping me-2" style="font-size: 1.2rem;"></i>
                    </a>
                </div>
                <p> {!! $product->description !!} </p>
                <a href= "#review-form" class="btn review-button-product-detail col-md-12 mb-4">Write your Review</a>


            <div class="review-box mb-4">
                <h6><strong>Customer reviews</strong></h6>
                @forelse($reviews as $review)
                    <div class="d-flex mb-3 mt-4">
                        <div class="me-4 mt-2">
                            <i class="fa-solid fa-message fa-2x"></i>
                        </div>
                        <div>
                            <div class="star-rating">    
                                <strong>{{ $review->user->name ?? 'Anonymous' }}</strong>
                                {!! str_repeat('★', $review->rating) !!} {!! str_repeat('☆', 5 - $review->rating) !!}
                            </div>
                            <small>{{ $review->review }}</small>

                            @if (!empty($review->image_path))
                                @php
                                    $images = is_array($review->image_path) ? $review->image_path : json_decode($review->image_path, true);
                                @endphp
                                <div class="review-avatar d-flex mt-1">
                                    @foreach ($images as $img)
                                        <img src="{{ asset($img) }}" alt="review image" class="me-2" style="width: 60px; height: auto;">
                                    @endforeach
                                </div>
                            @endif
                        </div>
                    </div>
                    <hr>
                @empty
                    <p class="text-muted mt-3">No reviews yet. Be the first to review this product!</p>
                @endforelse
            </div>
        </div>
    </div>

            <!-- Review Section Full Width -->
             @auth
                @if($canReview)
                    <form id="submit-review-form" enctype="multipart/form-data">
                        @csrf
                        <div class="col-12 mt-4" id="review-form">
                            <h6><strong>Customer reviews</strong></h6>
                            <div class="review-box mt-2">
                                <div class="d-flex mb-3 mt-1">
                                    <!-- Preview Container -->
                                    <div class="review-avatar d-flex align-items-start me-3" id="image-preview">
                                        <!-- Default avatars -->
                                    </div>
                                    <input type="hidden" name="product_id" value="{{ $product->id }}">

                                    <textarea name="review" class="form-control flex-grow-1" rows="2" placeholder="Write your review"></textarea>
                                </div>

                                <div class="row">
                                    <div class="col-md-2">
                                        <label class="btn border mb-2" for="image-upload">
                                            <i class="fa-solid fa-images"></i> Add Image
                                        </label>
                                        <input type="file" id="image-upload" name="images[]" class="d-none" multiple accept="image/*">
                                    </div>

                                    <div class="col-md-7"></div>

                                    <div class="col-md-3">
                                        <div class="d-flex justify-content-end align-items-center me-1 gap-2">
                                        <div class="rating-stars d-flex">
                                                @for ($i = 5; $i >= 1; $i--)
                                                    <input type="radio" id="star{{ $i }}" name="rating" value="{{ $i }}" required>
                                                    <label for="star{{ $i }}" data-value="{{ $i }}"></label>
                                                @endfor
                                            </div>
                                            <button type="submit" class="btn btn-primary submit-btn-product-detail">Submit</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                @endif
            @endauth
             <!-- Similar Products Section -->
<div class="container py-4 mt-4">
    <h5 class="mb-3"><strong>Similar Products</strong></h5>

    <div class="similar-products-scroll">
        @foreach($similarProducts as $similar)
            @php
                $images = explode(',', $similar->image);
                $firstImage = $images[0] ?? null;
            @endphp

            <div class="card border-0 shadow-sm mx-2" style="min-width: 180px;">
                <a href="{{ route('product.detail', $similar->id) }}" class="zoom-wrapper" style="display: block; overflow: hidden;">
                    <img src="{{ asset('storage/' . trim($firstImage)) }}" class="card-img-top zoom-img" alt="{{ $similar->name }}">
                </a>
                <div class="card-body px-2 py-2">
                    <h6 class="card-title mb-1 text-truncate">{{ $similar->name }}</h6>
                    <p class="mb-0">
                        <del class="discount text-muted mb-1">Rs. {{ number_format($similar->price, 2) }}</del>
                        <span class="fw-bold text-brown">Rs. {{ number_format($similar->price - $similar->discount, 2) }}</span>
                    </p>
                </div>
            </div>
        @endforeach
    </div>
</div>

</div>

<!-- Script For Selected Size  -->
<script>
    // Get all size radio inputs
    const sizeRadios = document.querySelectorAll('input[name="size"]');
    const selectedSizeSpan = document.getElementById('selected-size');

    // Function to update selected size text
    function updateSelectedSize() {
        const selected = document.querySelector('input[name="size"]:checked');
        if (selected) {
            selectedSizeSpan.textContent = selected.value;
        }
    }

    // Listen for changes on all size inputs
    sizeRadios.forEach(radio => {
        radio.addEventListener('change', updateSelectedSize);
    });

    // Initialize with the pre-checked value
    updateSelectedSize();
</script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function () {
  $('.wishlist-toggle').click(function () {
    let productId = $(this).data('product-id');
    let icon = $(this).find('i');

    $.ajax({
      url: "{{ route('wishlist.toggle') }}",
      type: "POST",
      data: {
        _token: '{{ csrf_token() }}',
        product_id: productId
      },
      success: function (res) {
        if (res.status === 'added') {
          icon.removeClass('fa-regular').addClass('fa-solid');
        } else if (res.status === 'removed') {
          icon.removeClass('fa-solid').addClass('fa-regular');
        }
      },
    });
  });
});
</script>

<!-- End Of  Script For Selected Size  -->
<script>
$(document).ready(function () {
    // Capture color and size selections
    let selectedColor = '';
    let selectedSize = '';

    // Handle color selection
    $('input[name="color"]').on('change', function () {
        selectedColor = $(this).val(); // Store color ID
    });

    // Handle size selection
    $('input[name="size"]').on('change', function () {
        selectedSize = $(this).val(); // Store size value
        $('#selected-size').text(selectedSize); // Update displayed size
    });

    // Add to cart
    $(document).on('click', '.add-to-cart', function () {
        let productId = $(this).data('product-id');
        let $button = $(this);

        // Validate color and size selections
        if (!selectedColor || !selectedSize) {
            const modal = new bootstrap.Modal(document.getElementById('successModal'));
            document.getElementById('successModalMessage').innerText = 'Please select both a color and a size.';
            modal.show();
            return;
        }

        $.ajax({
            url: "{{ route('cart.add') }}",
            method: 'POST',
            data: {
                _token: "{{ csrf_token() }}",
                product_id: productId,
                color_id: selectedColor, // Pass color ID
                size: selectedSize,      // Pass size
                quantity: 1             // Default quantity
            },
            success: function (res) {
                if (res.status === 'success') {
                        @auth
                        let qtyHtml = `
                            <div class="d-flex justify-content-start">
                                <div class="input-group quantity-selector rounded" style="width: 100px; height:35px;" data-product-id="${productId}" data-color-id="${selectedColor}" data-size="${selectedSize}">
                                    <button class="btn btn-sm text-white bg-maroon qty-decrease">−</button>
                                    <input type="text" class="form-control text-center cart-qty" value="${res.quantity}" readonly>
                                    <button class="btn btn-sm text-white bg-maroon qty-increase">+</button>
                                </div>
                            </div>
                        `;
                        $button.replaceWith(qtyHtml);
                        @endauth

                        // Show success message and "Go to Cart" button
                        document.getElementById('successModalLabel').innerText = '';
                        document.getElementById('successModalMessage').innerText = res.message;
                        document.getElementById('modalActionButton').classList.remove('d-none');

                        const modal = new bootstrap.Modal(document.getElementById('successModal'));
                        modal.show();
                    }
                    else if (res.status === 'unauthenticated') {
                    document.getElementById('successModalMessage').innerText = 'Please log in to Add Product In Your Cart.';
                    document.getElementById('successModalLabel').innerText = 'Notice';

                    // Show the modal
                    const modal = new bootstrap.Modal(document.getElementById('successModal'));
                    modal.show();
                }
            },
            error: function () {
                document.getElementById('successModalMessage').innerText = 'Please log in to Add Product In Your Cart.';
                    document.getElementById('successModalLabel').innerText = 'Notice';

                    // Show the modal
                    const modal = new bootstrap.Modal(document.getElementById('successModal'));
                    modal.show();
            }
        });
    });

    // Increase quantity
    $(document).on('click', '.qty-increase', function () {
        let $selector = $(this).closest('.quantity-selector');
        let productId = $selector.data('product-id');
        let colorId = $selector.data('color-id'); // Retrieve color ID
        let size = $selector.data('size');        // Retrieve size
        let $qtyInput = $selector.find('.cart-qty');
        let qty = parseInt($qtyInput.val()) + 1;

        $.ajax({
            url: "{{ route('cart.update') }}",
            method: 'POST',
            data: {
                _token: "{{ csrf_token() }}",
                product_id: productId,
                color_id: colorId, // Pass color ID
                size: size,       // Pass size
                quantity: qty
            },
            success: function (res) {
                if (res.status === 'success') {
                    $qtyInput.val(res.quantity);
                    showSuccessModal(res.message);
                }
            },
            // error: function () {
            //     alert('Something went wrong!');
            // }
        });
    });

    // Decrease quantity
    $(document).on('click', '.qty-decrease', function () {
        let $selector = $(this).closest('.quantity-selector');
        let productId = $selector.data('product-id');
        let colorId = $selector.data('color-id'); // Retrieve color ID
        let size = $selector.data('size');        // Retrieve size
        let $qtyInput = $selector.find('.cart-qty');
        let qty = parseInt($qtyInput.val());

        if (qty <= 1) {
            // Remove from cart
            $.ajax({
                url: "{{ route('cart.remove') }}",
                method: 'POST',
                data: {
                    _token: "{{ csrf_token() }}",
                    product_id: productId,
                    color_id: colorId, // Pass color ID
                    size: size        // Pass size
                },
                success: function (res) {
                    if (res.status === 'success') {
                        let addBtn = `
                            <a href="javascript:void(0);"
                               class="btn cart-button-product-detail add-to-cart col-md-12" 
                               data-product-id="${productId}">
                               Add to Cart
                            </a>
                        `;
                        $selector.replaceWith(addBtn);

                        showSuccessModal(res.message);
                    }
                },
                error: function () {
                    alert('Something went wrong!');
                }
            });
        } else {
            qty -= 1;

            $.ajax({
                url: "{{ route('cart.update') }}",
                method: 'POST',
                data: {
                    _token: "{{ csrf_token() }}",
                    product_id: productId,
                    color_id: colorId, // Pass color ID
                    size: size,       // Pass size
                    quantity: qty
                },
                success: function (res) {
                    if (res.status === 'success') {
                        $qtyInput.val(res.quantity);
                        showSuccessModal(res.message);
                    }
                },
                error: function () {
                    alert('Something went wrong!');
                }
            });
        }
    });

    // Reusable success modal function
    function showSuccessModal(message) {
        $('#successModalMessage').text(message);
        var modal = new bootstrap.Modal(document.getElementById('successModal'));
        modal.show();
    }
});
</script>
<!-- ------------------------------------------------------------------------------------------------------------ -->
<!-- Script for displaying preview of uploded image and submit of review form -->
 <script>
document.getElementById('image-upload').addEventListener('change', function (event) {
    const files = event.target.files;
    const previewContainer = document.getElementById('image-preview');

    // Remove previously uploaded previews except default
    previewContainer.querySelectorAll('img:not([src*="7421_49-46_"])').forEach(img => img.remove());

    Array.from(files).forEach(file => {
        if (!file.type.startsWith('image/')) return;

        const reader = new FileReader();
        reader.onload = function (e) {
            const img = document.createElement('img');
            img.src = e.target.result;
            img.className = 'me-2';
            img.style.width = '50px';
            img.style.height = '60px';
            img.style.objectFit = 'fill';
            previewContainer.appendChild(img);
        };
        reader.readAsDataURL(file);
    });
});

document.getElementById('submit-review-form').addEventListener('submit', function (e) {
    e.preventDefault();

    const formData = new FormData(this);

    fetch("{{ route('product.review') }}", {
        method: "POST",
        headers: {
            'X-CSRF-TOKEN': document.querySelector('input[name="_token"]').value,
            'Accept': 'application/json'
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.status === 'success') {
            alert('Review submitted successfully!');
            // Optionally reset the form or update reviews list
            this.reset();
            document.getElementById('image-preview').querySelectorAll('img:not([src*="7421_49-46_"])').forEach(img => img.remove());
        } else {
            alert('Something went wrong!');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Error submitting review.');
    });
});
</script>
<script>
function shareCurrentPage(productName) {
    const currentUrl = window.location.href;

    if (navigator.share) {
        navigator.share({
            title: productName,
            text: 'Check out this product!',
            url: currentUrl,
        }).catch((err) => console.error('Share failed:', err));
    } else {
        // Fallback if Web Share API not supported
        const shareText = encodeURIComponent(`Check out this product: ${productName}`);
        const shareLink = encodeURIComponent(currentUrl);

        const fb = `https://www.facebook.com/sharer/sharer.php?u=${shareLink}`;
        const wa = `https://wa.me/?text=${shareText}%20${shareLink}`;

        window.open(fb, '_blank'); // or use wa if preferred
    }
}
</script>

<script>
  document.addEventListener("DOMContentLoaded", function () {
    const previewImages = document.querySelectorAll('.preview-image');
    const modalImg = document.getElementById('previewModalImage');
    const modal = new bootstrap.Modal(document.getElementById('imagePreviewModal'));
    const prevBtn = document.querySelector('.prev-img');
    const nextBtn = document.querySelector('.next-img');

    let currentIndex = 0;
    const imageUrls = Array.from(previewImages).map(img => img.getAttribute('data-img'));

    previewImages.forEach((img, index) => {
      img.addEventListener('click', function () {
        currentIndex = parseInt(this.getAttribute('data-index'));
        modalImg.src = imageUrls[currentIndex];
      });
    });

    function updateModalImage() {
      modalImg.src = imageUrls[currentIndex];
    }

    prevBtn.addEventListener('click', function () {
      currentIndex = (currentIndex - 1 + imageUrls.length) % imageUrls.length;
      updateModalImage();
    });

    nextBtn.addEventListener('click', function () {
      currentIndex = (currentIndex + 1) % imageUrls.length;
      updateModalImage();
    });
  });
</script>
<script>
    document.querySelectorAll('.color-label').forEach(label => {
    label.addEventListener('click', function () {
        const colorName = this.getAttribute('data-color-name');
        document.getElementById('selected-color-name').innerText = colorName;

        const selectedColorId = this.getAttribute('for').split('-')[1];

        // Hide all color image groups
        document.querySelectorAll('.image-group').forEach(group => {
            group.style.display = 'none';
        });

        // Show the selected color's image group
        const targetGroup = document.querySelector(`.image-group[data-color-id="${selectedColorId}"]`);
        if (targetGroup) targetGroup.style.display = 'block';
    });
});

</script>

<script>
  document.addEventListener("DOMContentLoaded", function () {
    const previewImages = document.querySelectorAll('.preview-image');
    const modalImg = document.getElementById('previewModalImage');
    const modal = new bootstrap.Modal(document.getElementById('imagePreviewModal'));
    const prevBtn = document.querySelector('.prev-img');
    const nextBtn = document.querySelector('.next-img');

    let currentIndex = 0;
    let imageUrls = Array.from(previewImages).map(img => img.getAttribute('data-img'));

    previewImages.forEach((img, index) => {
      img.addEventListener('click', function () {
        currentIndex = parseInt(this.getAttribute('data-index'));
        modalImg.src = imageUrls[currentIndex];
      });
    });

    function updateModalImage() {
      modalImg.src = imageUrls[currentIndex];
    }

    prevBtn.addEventListener('click', function () {
      currentIndex = (currentIndex - 1 + imageUrls.length) % imageUrls.length;
      updateModalImage();
    });

    nextBtn.addEventListener('click', function () {
      currentIndex = (currentIndex + 1) % imageUrls.length;
      updateModalImage();
    });
  });
</script>
<script>
  document.addEventListener('DOMContentLoaded', function () {
    const goToCartBtn = document.getElementById('goToCartBtn');
    if (goToCartBtn) {
        goToCartBtn.addEventListener('click', function (e) {
            e.preventDefault(); // prevent immediate navigation
            const modal = bootstrap.Modal.getInstance(document.getElementById('successModal'));
            modal.hide(); // close modal

            // Navigate after a short delay
            setTimeout(() => {
                window.location.href = this.href;
            }, 300); // adjust delay if needed
        });
    }
  });
</script>



<!-- ------------------------------------------------------------------------------------------------------------ -->
<!-- ------------------------------------------------------------------------------------------------------------ -->
@endsection
<style>
.rating-stars {
    direction: rtl;
    display: flex;
    gap: 0.5rem;
}

.rating-stars input[type="radio"] {
    display: none;
}

.rating-stars label {
    font-size: 1.8rem;
    color: #ccc;
    cursor: pointer;
    transition: color 0.2s;
}

.rating-stars label::before {
    font-family: "Font Awesome 6 Free";
    content: "\f006"; /* star */
    font-weight: 100; /* outlined */
}

.rating-stars input[type="radio"]:checked ~ label::before,
.rating-stars label:hover::before,
.rating-stars label:hover ~ label::before {
    font-weight: 400; /* solid star */
    color: #ffc107;
}



    .zoomable {
  transition: transform 0.3s ease;
  cursor: zoom-in;
}
.zoomable:hover {
  transform: scale(1.15);
}
/* Scrollable left image section */
.image-scroll-wrapper {
    height: calc(100vh - 80px); /* Adjust 80px to match your actual header height */
    overflow-y: auto;
    scroll-behavior: smooth;
    scrollbar-width: none;
    -ms-overflow-style: none;
}
@media (max-width: 576px) {
    .image-scroll-wrapper {
        height: 450px; /* Less margin on smaller screens if needed */
        padding: 0 10px;
    }
}

.image-scroll-wrapper::-webkit-scrollbar {
    display: none; /* Chrome, Safari */
}

/* Fixed description - no scroll inside */
.sticky-description {
    position: sticky;
    top: 0;
    align-self: flex-start;
}
.zoom-wrapper .zoom-img {
        transition: transform 0.4s ease;
    }

    .zoom-wrapper:hover .zoom-img {
        transform: scale(1.1); /* increase value for stronger zoom */
    }
    .color-label {
        cursor: pointer;
        border: 1px solid transparent;
        transition: border-color 0.3s ease;
    }

    .btn-check:checked + .color-label {
        border-color:rgb(58, 152, 108); /* Bootstrap green or customize */
        box-shadow: 0 0 0 1px rgba(25, 135, 84, 0.25);
    }
</style>
