@extends('layouts/layout')

@section('content')


<div  style="background-color: #FFF6EA;">
        <div class="d-block d-md-none text-end mt-3  me-3">
            <button class="btn " style="background-color: #f4cccc; color: #5b2c2c;" data-bs-toggle="modal" data-bs-target="#filterModal">
                <i class="fa fa-sliders"></i> Filters
            </button>
        </div>
        <div class="modal fade" id="filterModal" tabindex="-1" aria-labelledby="filterModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-scrollable">
                <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="filterModalLabel">Filters</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <!-- You can extract and reuse the sidebar filter content -->
                    <div class="filters-header d-flex justify-content-between align-items-center">
                        <h5>FILTERS</h5>
                        <a href="{{ route('New-Arrival') }}">CLEAR ALL</a>
                    </div>
                    <hr class="filter-border">

                    <!-- Categories -->
                    <div class="filter-group">
                        <div class="filter-title d-flex justify-content-between align-items-center">
                            <h5>CATEGORIES</h5>
                            <i class="fa-solid fa-magnifying-glass" id="toggle-category-search" style="cursor: pointer;"></i>
                        </div>

                        <input type="text" id="category-search-input" class="form-control mt-2 mb-2 d-none" placeholder="Search categories...">

                        <ul class="checkbox-list">
                            @php $selectedCategoryId = request()->segment(2); @endphp
                            @foreach($categories as $category)
                                <li>
                                    <label>
                                        <input type="checkbox" class="filter-category" value="{{ $category->id }}"
                                            {{ $selectedCategoryId == $category->id ? 'checked' : '' }}>
                                        <span class="checkmark"></span> {{ $category->title }}
                                    </label>
                                </li>
                            @endforeach
                        </ul>
                    </div>

                    <hr class="filter-border">

                    <!-- Colors -->
                    <div class="filter-group">
                        <h4>COLORS</h4>
                        <ul class="checkbox-list">
                            @foreach ($colors as $color)
                                <li>
                                    <label>
                                        <input type="checkbox" class="filter-color" value="{{ $color->id }}">
                                        <span class="checkmark"></span> {{ ucfirst($color->color_name) }}
                                    </label>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
                </div>
            </div>
        </div>

  <div class="container-new-arrivals position-relative">


    <!-- Sidebar -->
    <aside class="sidebar d-none d-md-block">
        <div class="filters-header">
            <h5>FILTERS</h5>
            <a href="{{ route('New-Arrival') }}">CLEAR ALL</a>
        </div>
        <hr class="filter-border">

        <!-- Categories -->
        <div class="filter-group">
            <div class="filter-title d-flex justify-content-between align-items-center">
                <h5>CATEGORIES</h5>
                <i class="fa-solid fa-magnifying-glass" id="toggle-category-search" style="cursor: pointer;"></i>
            </div>

            <!-- Search Input (hidden by default) -->
            <input type="text" id="category-search-input" class="form-control mt-2 mb-2 d-none" placeholder="Search categories...">

            <ul class="checkbox-list">
               @php
                    $selectedCategoryId = request()->segment(2); 
                @endphp

                @foreach($categories as $category)
                    <li>
                        <label>
                            <input type="checkbox" class="filter-category" value="{{ $category->id }}"
                                {{ $selectedCategoryId == $category->id ? 'checked' : '' }}>
                            <span class="checkmark"></span> {{ $category->title }}
                        </label>
                    </li>
                @endforeach

            </ul>
        </div>
        <hr class="filter-border">

        <!-- Colors -->
        <div class="filter-group">
            <h4>COLORS</h4>
            <ul class="checkbox-list">
                @foreach ($colors as $color)
                    <li>
                        <label>
                            <input type="checkbox" class="filter-color" value="{{ $color->id }}">
                            <span class="checkmark"></span> {{ ucfirst($color->color_name) }}
                        </label>
                    </li>
                @endforeach
            </ul>
        </div>


    </aside>


    <!-- Product Grid -->
    <main class="products" id="product-list">
      <!-- Repeat this .product-card block -->
   
      @foreach($products as $product)
            <div class="product-card">
                <div class="image-wrapper position-relative">
                    @php
                        $productImages = $product->images->pluck('image_path')->toArray();
                        $mainImage = $productImages[0] ?? 'images/no-image.png';
                        $hoverImage = $productImages[1] ?? $mainImage; // fallback if only 1 image
                    @endphp
                    <a href="{{ route('product.detail', $product->id) }}">
                        <img src="{{ asset('storage/' . $product->image) }}" alt="{{ $product->name }}" class="img-fluid">
                        <img src="{{ asset('storage/' . $hoverImage) }}" class="hover-img img-fluid position-absolute top-0 start-0">
                     </a>
                </div>
                <div class="info">
                    <p class="name">{{ $product->name }}</p>
                    <a href="javascript:void(0);"
                                    class="position-absolute wishlist-toggle text-brown"
                                    data-product-id="{{ $product->id }}"
                                    style="top: 10px; right: 10px; z-index: 2;">
                                    <i class="fa-{{ in_array($product->id, $wishlistIds) ? 'solid' : 'regular' }} fa-heart fs-4 text-brown"></i>
                                    </a>
                    <p class="price justify-content-center gap-3 fw-bold">
                        @if($product->discount)
                            <span class="discount">Rs.{{ number_format($product->price) }}</span>
                            <span>Rs.{{ number_format($product->price - $product->discount) }}</span>
                        @else
                            <span>Rs.{{ number_format($product->price) }}</span>
                        @endif
                    </p>
                </div>
            </div>
        @endforeach
    </main>
  </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {

        // ✅ Toggle category search input when magnifier clicked
        const toggleIcon = document.getElementById('toggle-category-search');
        const searchInput = document.getElementById('category-search-input');

        toggleIcon.addEventListener('click', function () {
            searchInput.classList.toggle('d-none');
            if (!searchInput.classList.contains('d-none')) {
                searchInput.focus();
            } else {
                searchInput.value = '';
                filterCategories('');
            }
        });

        // ✅ Live filter category list
        searchInput.addEventListener('keyup', function () {
            const query = this.value.toLowerCase();
            filterCategories(query);
        });

        function filterCategories(query) {
            const items = document.querySelectorAll('.filter-category');
            items.forEach(cb => {
                const label = cb.closest('label');
                const listItem = cb.closest('li');
                const text = label.textContent.toLowerCase();
                listItem.style.display = text.includes(query) ? 'block' : 'none';
            });
        }

        // ✅ Filtering logic for categories & colors
        const categoryCheckboxes = document.querySelectorAll('.filter-category');
        const colorCheckboxes = document.querySelectorAll('.filter-color');

        function getSelectedValues(className) {
            return Array.from(document.querySelectorAll('.' + className + ':checked')).map(cb => cb.value);
        }

        function applyFilters() {
            const categories = getSelectedValues('filter-category');
            const colors = getSelectedValues('filter-color');
            const filterUrl = "{{ url('/filter-products') }}";
            
            fetch(`${filterUrl}?categories=${categories.join(',')}&colors=${colors.join(',')}`)
                .then(res => res.json())
                .then(data => {
                    document.getElementById('product-list').innerHTML = data.html;
                });
        }

        categoryCheckboxes.forEach(cb => cb.addEventListener('change', applyFilters));
        colorCheckboxes.forEach(cb => cb.addEventListener('change', applyFilters));
    });
</script>
<script>
$(document).ready(function () {
  $('.wishlist-toggle').click(function () {
    let productId = $(this).data('product-id');
    let icon = $(this).find('i');

    $.ajax({
      url: "{{ route('wishlist.toggle') }}",
      type: "POST",
      data: {
        _token: '{{ csrf_token() }}',
        product_id: productId
      },
      success: function (res) {
        if (res.status === 'added') {
          icon.removeClass('fa-regular').addClass('fa-solid');
        } else if (res.status === 'removed') {
                icon.closest('.col-lg-3').remove();

                // Optional: Check if any wishlist items remain, show empty message
                if ($('#wishlistProductContainer').children('.col-lg-3').length === 0) {
                    $('#wishlistProductContainer').html(`
                    <div class="col-12 text-center">
                        <p class="text-muted">Your wishlist is empty.</p>
                        <a href="{{ url('/') }}" class="btn btn-primary mt-3">Continue Shopping</a>
                    </div>
                    `);
                }
            }
      },
      error: function (xhr) {
        if (xhr.status === 401) {
          alert('Please log in to use the wishlist.');
        }
      }
    });
  });
});
</script>
@endsection
