@extends('layouts/layout')

@section('content')

<!-- Category - Section  ------------------------------------------------------------------------ -->
<section class="category-section" style="background-color: #FFF6EA;">
  <div class="container py-4 mt-3">
    <div class="category-slider">
        @foreach ($categories as $category)
            <div class="category-item text-center">
                  <a href="{{ route('New-Arrival-Id', $category->id) }}" class="text-decoration-none text-brown">
                      <div class="d-flex justify-content-center">
                          <img src="{{ asset('storage/' . $category->image) }}"  
                              class="img-fluid rounded" 
                              style="width: 150px; height: 150px; object-fit: fit;">
                        </div>
                        <p class="mt-2 fw-semibold">{{$category->title}}</p>
                    </a>
              </div>
          @endforeach
    </div>
  </div>
</section>
<!-- End Category - Section ------------------------------------------------------------------------- -->




<!-- Scrolling Banner Carousel -->
<div id="bannerCarousel" class="carousel slide" data-bs-ride="carousel" >
  <div class="carousel-inner">
     <div class="carousel-item active">
          <div class="bottom-banner mt-0">
            <div class="container position-relative">
                <img src="{{ asset('images/bcf9024d7377859687e8c9516858baf55455abb8.png') }}" alt="" class="banner-image">
                <a href="{{ route('New-Arrival-Id', 3) }}" class="btn  explore-all-btn first-banner-btn">Explore </a>
            </div>
        </div>
      </div>
      <div class="carousel-item ">
        <div class="bottom-banner mt-0">
            <div class="container position-relative">
                <img src="{{ asset('images/bcf9024d7377859687e8c9516858baf55455abb8.png') }}" alt="" class="banner-image">
                <a href="{{ route('New-Arrival-Id', 3) }}" class="btn  explore-all-btn first-banner-btn">Explore</a>
            </div>
          </div>
      </div>
      <div class="carousel-item ">
         <div class="bottom-banner mt-0">
             <div class="container position-relative">
                 <img src="{{ asset('images/bcf9024d7377859687e8c9516858baf55455abb8.png') }}" alt="" class="banner-image">
                 <a href="{{ route('New-Arrival-Id', 3) }}" class="btn  explore-all-btn first-banner-btn">Explore</a>
             </div>
           </div>
      </div>
  </div>
</div>
<!-- Scrolling Banner Carousel ------------------------------------------------------------------------- -->



  <!-- Categories Section -->
  <div class="categories-section">
        <div class="container">
            <!-- Category Buttons -->
            <div class="d-flex flex-nowrap justify-content-center gap-5 mb-4 px-2 overflow-auto" style="white-space: nowrap;position: sticky; top: 85px; z-index: 1000; background-color:#FFF6EA; padding:15px;">
                @foreach ($categories as $category)
                  @if (!in_array($category->id, [9, 10]))
                      <button class="btn custom" data-category="{{ $category->title }}">{{ Str::limit($category->title, 14, '') }}</button>
                    @endif
                @endforeach
                <button class="btn custom" data-category="all">See All</button>
            </div>

          <!-- Product Grid -->
          <div class="row g-4" id="productContainer">
              @foreach ($products as $product)
                  <div class="col-md-4 product-item category-card" data-category="{{ $product->category->title ?? '' }}">
                      <div class="image-wrapper position-relative">
                          <!-- Heart Icon Link (outside image link) -->
                          <a href="javascript:void(0);" 
                            class="heart-icon position-absolute wishlist-toggle text-brown" 
                            data-product-id="{{ $product->id }}"
                            style="top: 10px; right: 10px; z-index: 2;">
                            <!-- <i class="fa{{ in_array($product->id, $wishlistIds) ? 's' : 'r' }} fa-heart fs-4 text-brown"></i> -->
                            <i class="fa-{{ in_array($product->id, $wishlistIds) ? 'solid' : 'regular' }} fa-heart fs-4 text-brown"></i>
                          </a>
                          <!-- Image Link -->
                           @php
                              $productImages = $product->images->pluck('image_path')->toArray();
                              $mainImage = $productImages[0] ?? 'images/no-image.png';
                              $hoverImage = $productImages[1] ?? $mainImage; // fallback if only 1 image
                          @endphp
                          <a href="{{ route('product.detail', $product->id) }}" class="text-decoration-none d-block">
                            <img src="{{ asset('storage/' . $product->image) }}" class="main-img img-fluid" alt="Product">
                            <img src="{{ asset('storage/' . $hoverImage) }}" class="hover-img img-fluid position-absolute top-0 start-0">
                          </a>
                      </div>
                  </div>
                @endforeach
                <div class="text-center mt-4">
                    <a href="{{ route('New-Arrival') }}" class="btn custom explore-all-btn">Explore All <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-linecap="round" stroke-width="1.5"><path stroke-linejoin="round" d="M8 12h8m0 0l-3-3m3 3l-3 3"/><path d="M22 12c0 4.714 0 7.071-1.465 8.535C19.072 22 16.714 22 12 22s-7.071 0-8.536-1.465C2 19.072 2 16.714 2 12s0-7.071 1.464-8.536C4.93 2 7.286 2 12 2s7.071 0 8.535 1.464c.974.974 1.3 2.343 1.41 4.536"/></g></svg></a>
                </div>
            </div>
          </div>
    </div>

<!-- Scrolling Banner Carousel -->
<div id="bannerCarousel" class="carousel slide" data-bs-ride="carousel">
  <div class="carousel-inner">
     <div class="carousel-item active">
        <div class="bottom-banner mt-0">
            <div class="container position-relative">
                <img src="images/ee0d0d2aa58029781fe8c4a280b2afa8d8649e84.png" alt="Logo" class="banner-image">
                <a href="{{ route('New-Arrival-Id', 9) }}" class="btn banner-two explore-all-btn">Explore All Looks </a>
            </div>
        </div>
      </div>
      <div class="carousel-item ">
         <div class="bottom-banner mt-0">
             <div class="container position-relative">
                 <img src="images/ee0d0d2aa58029781fe8c4a280b2afa8d8649e84.png" alt="Logo" class="banner-image">
                 <a href="{{ route('New-Arrival-Id', 9) }}" class="btn banner-two explore-all-btn">Explore All Looks</a>
             </div>
         </div>
      </div>

      <div class="carousel-item ">
         <div class="bottom-banner mt-0">
             <div class="container position-relative">
                 <img src="images/ee0d0d2aa58029781fe8c4a280b2afa8d8649e84.png" alt="Logo" class="banner-image">
                 <a href="{{ route('New-Arrival-Id', 9) }}" class="btn banner-two explore-all-btn">Explore All Looks</a>
             </div>
         </div>
      </div>
  </div>
</div>


<section class="daily-style-section py-5" style="background-color: #FFF6EA;">
  <div class="container" style="width: 100%;">
    <div class="style-carousel">

      <!-- Card 1 -->
      <div>
        <div class="style-card position-relative">
          <img src="images/1aed2e4d1d6cc00033e5295547bd2d46f55e04ad.png" alt="Style 1" class="img-fluid style-img">
          <div class="style-overlay">
            <a href="{{ route('New-Arrival-Id', 10) }}" class="btn explore-all-btn style-btn">Explore All Looks</a>
          </div>
        </div>
      </div>

      <!-- Card 2 -->
      <div>
        <div class="style-card position-relative">
          <img src="images/1aed2e4d1d6cc00033e5295547bd2d46f55e04ad.png" alt="Style 2" class="img-fluid style-img">
          <div class="style-overlay">
            <a href="{{ route('New-Arrival-Id', 10) }}" class="btn explore-all-btn style-btn">Explore All Looks</a>
          </div>
        </div>
      </div>

      <!-- Card 3 -->
      <div>
        <div class="style-card position-relative">
          <img src="images/1aed2e4d1d6cc00033e5295547bd2d46f55e04ad.png" alt="Style 3" class="img-fluid style-img">
          <div class="style-overlay">
            <a href="{{ route('New-Arrival-Id', 10) }}" class="btn explore-all-btn style-btn">Explore All Looks</a>
          </div>
        </div>
      </div>

        <!-- Card 3 -->
      <div>
        <div class="style-card position-relative">
          <img src="images/1aed2e4d1d6cc00033e5295547bd2d46f55e04ad.png" alt="Style 3" class="img-fluid style-img">
          <div class="style-overlay">
            <a href="{{ route('New-Arrival-Id', 10) }}" class="btn explore-all-btn style-btn">Explore All Looks</a>
          </div>
        </div>
      </div>

    </div>
  </div>
</section>


<!-- Categories Section -->
<div class="categories-section">
  <div class="container">
      <h2 class="mb-2 poltawski-font">Boutique Looks in Action</h2>
  </div>
</div>
<section class="scrolling-product-section">
    <div class="scrolling-wrapper">
        @foreach($products as $product)
            @if(!empty($product->product_video) && \Storage::disk('public')->exists($product->product_video))
                <div class="product-video-card">
                    <div class="product-image">
                        <video autoplay loop muted playsinline
                            class="product-preview"
                             data-id="{{ $product->id }}"
                            data-video="{{ asset('storage/' . $product->product_video) }}"
                            data-title="{{ $product->name }}"
                            data-size ="{{ $product->size}}"
                            data-color ="{{ $product->color}}"
                            data-thumb="{{ asset('storage/' . ($product->image ?? '')) }}"
                            data-price="₹{{ $product->price - $product->discount }}"
                            data-original="₹{{ $product->price }}"
                            data-discount="{{ $product->discount }}OFF"
                        >
                            <source src="{{ asset('storage/' . $product->product_video) }}" type="video/mp4">
                            Your browser does not support the video tag.
                        </video>
                    </div>
                    <div class="product-title">{{ $product->name }}</div>
                </div>
            @endif
        @endforeach
    </div>
</section>



<!-- Instagram Section -->


<section class="instagram-section">
  <div class="container">
    <div class="insta-header">
      <img src="images/d6355990a69bcfe17bcd4d24ce5932c8cfd2c793.png" alt="C3 Logo" class="insta-logo">
      <div class="insta-text">
        <p class="insta-tagline">Feel it. Wear it. Own it.</p>
        <p class="insta-followers">931k followers</p>
        <h2 class="insta-title">C3 ON INSTAGRAM</h2>
      </div>
    </div>

    <div class="insta-scroll-wrapper">
      <!-- Instagram image cards -->
      @foreach($posts as $post)
        <div class="insta-card">
           <div class="instagram-embed-wrapper" style="overflow: hidden; width: 100%; height: 100%;">
                                            {!! $post->embed_link !!}
                                        </div>
        </div>
        
    @endforeach

</section>

<!-- ------------------------------------------------------------------------------------------------------------ -->
<!-- Script of Storing Wishlist  -------------------------------------------------------------------------------- -->
<!-- Add to your HTML -->
<style>
.video-modal {
  position: fixed;
  inset: 0;
  background: rgba(0, 0, 0, 0.85);
  z-index: 9999;
  display: flex;
  align-items: center;
  justify-content: center;
}

.modal-overlay {
  width: 100%;
  height: 100%;
  position: relative;
  display: flex;
  align-items: center;
  justify-content: center;
}

.modal-wrapper {
  display: flex;
  align-items: center;
  gap: 40px;
  max-width: 90vw;
  width: 100%;
  justify-content: center;
}

.center-video-box {
  position: relative;
  background: #000;
  border-radius: 10px;
  overflow: hidden;
  max-width: 400px;
  width: 100%;
  box-shadow: 0 0 20px rgba(255, 255, 255, 0.1);
}

.center-video-box video {
  width: 100%;
  height: auto;
  max-height: 500px; 
  display: block;
  object-fit: fill;
}

.product-details {
  position: absolute;
  bottom: 10px;
  left: 10px;
  right: 10px;
  background: rgba(255, 255, 255, 0.95);
  border-radius: 10px;
  padding: 10px;
  display: flex;
  align-items: center;
  gap: 10px;
}

.product-thumbnail {
  width: 50px;
  height: 65px;
  object-fit: cover;
  border-radius: 6px;
}

.product-info h4 {
  font-size: 13px;
  margin: 0;
  font-weight: 600;
  color: #000;
}

.price-section {
  font-size: 12px;
  display: flex;
  align-items: center;
  gap: 5px;
}

.price {
  font-weight: bold;
  color: #000;
}

.original-price {
  text-decoration: line-through;
  color: #999;
}

.discount {
  color: green;
  font-weight: bold;
}

.add-to-cart-btn {
  margin-top: 6px;
  background: #000;
  color: #fff;
  padding: 6px 10px;
  border: none;
  font-size: 12px;
  width: 100%;
  border-radius: 4px;
  cursor: pointer;
}

.side-preview {
  width: 120px;
  height: auto;
  overflow: hidden;
  border-radius: 10px;
  background: #fff;
  display: flex;
  align-items: center;
  justify-content: center;
}

.side-preview img {
  width: 100%;
  height: auto;
  object-fit: cover;
  border-radius: 10px;
}

.close-btn {
  position: absolute;
  top: 20px;
  right: 30px;
  background: #fff;
  color: #000;
  border-radius: 50%;
  width: 32px;
  height: 32px;
  font-size: 18px;
  font-weight: bold;
  text-align: center;
  line-height: 32px;
  cursor: pointer;
  z-index: 10001;
}

@media (max-width: 768px) {
  .modal-wrapper {
    flex-direction: column;
    gap: 20px;
  }
  .side-preview {
    display: none;
  }
  .center-video-box {
    max-width: 90%;
  }
}
</style>

<!-- Modal -->
<div id="videoModal" class="video-modal" style="display: none;">
  <div class="modal-overlay">
    <span class="close-btn" onclick="closeModal()">&#10006;</span>
    <div class="modal-wrapper">
      <div class="side-preview" id="prevPreview"></div>

      <div class="center-video-box">
        <video id="modalVideo" autoplay muted loop playsinline>
          <source id="modalVideoSource" src="" type="video/mp4">
          Your browser does not support the video tag.
        </video>

        <div class="product-details">
          <img class="product-thumbnail" id="productThumb" src="" alt="Thumbnail">
          <div class="product-info ">
            <h4 id="videoTitle">Product Title</h4>
            <div class="price-section">
              <span class="price" id="price">₹ 0.0</span>
              <span class="original-price" id="originalPrice">₹ 0.0</span>
              <span class="discount" id="discount">0% OFF</span>
            </div>
            <a href="" class="add-to-cart-btn">More</a>
          </div>
        </div>
      </div>

      <div class="side-preview" id="nextPreview"></div>
    </div>
  </div>
</div>


<script>
const modal = document.getElementById('videoModal');
const modalVideo = document.getElementById('modalVideo');
const modalVideoSource = document.getElementById('modalVideoSource');
const videoTitle = document.getElementById('videoTitle');
const productThumb = document.getElementById('productThumb');
const price = document.getElementById('price');
const originalPrice = document.getElementById('originalPrice');
const discount = document.getElementById('discount');
const prevPreview = document.getElementById('prevPreview');
const nextPreview = document.getElementById('nextPreview');

const previewVideos = document.querySelectorAll('.product-preview');
let currentIndex = 0;

const productData = [];

previewVideos.forEach((video, index) => {
  productData.push({
    id: video.dataset.id,
    video: video.dataset.video,
    title: video.dataset.title,
    thumb: video.dataset.thumb || "",
    price: video.dataset.price,
    original: video.dataset.original,
    discount: video.dataset.discount,
  });

  video.addEventListener('click', () => {
    currentIndex = index;
    openModal(index);
  });
});

function openModal(index) {
  const data = productData[index];
  modalVideo.pause();
  modalVideo.src = data.video;
  modalVideo.load();
  modalVideo.play();
  videoTitle.innerText = data.title;
  productThumb.src = data.thumb;
  price.innerText = data.price;
  originalPrice.innerText = data.original;
  discount.innerText = data.discount;

   // Set the "More" button href
  const moreBtn = document.querySelector('.add-to-cart-btn');
  moreBtn.href = `/product-Detail/${data.id}`; // <-- Laravel route

  modal.style.display = 'flex';

  const prevIndex = (index - 1 + productData.length) % productData.length;
  const nextIndex = (index + 1) % productData.length;
  prevPreview.innerHTML = `<img src="${productData[prevIndex].thumb}" alt="Prev">`;
  nextPreview.innerHTML = `<img src="${productData[nextIndex].thumb}" alt="Next">`;
}

function closeModal() {
  modal.style.display = 'none';
  modalVideo.pause();
}

function prevVideo() {
  currentIndex = (currentIndex - 1 + productData.length) % productData.length;
  openModal(currentIndex);
}

function nextVideo() {
  currentIndex = (currentIndex + 1) % productData.length;
  openModal(currentIndex);
}

prevPreview.addEventListener('click', prevVideo);
nextPreview.addEventListener('click', nextVideo);

</script>
<script async src="https://www.instagram.com/embed.js"></script>
<!-- ---------------------- -->
 <script>
      // Add to cart
    $(document).on('click', '.add-to-cart', function () {
        let productId = $(this).data('product-id');
        let $button = $(this);

        // Validate color and size selections
        if (!selectedColor || !selectedSize) {
            alert('Please select both a color and a size.');
            return;
        }

        $.ajax({
            url: "{{ route('cart.add') }}",
            method: 'POST',
            data: {
                _token: "{{ csrf_token() }}",
                product_id: productId,
                color_id: selectedColor, // Pass color ID
                size: selectedSize,      // Pass size
                quantity: 1             // Default quantity
            },
            success: function (res) {
                if (res.status === 'success') {
                    let qtyHtml = `
                        <div class="d-flex justify-content-center">
                            <div class="input-group quantity-selector mt-1 rounded" style="width: 80px;" data-product-id="${productId}" data-color-id="${selectedColor}" data-size="${selectedSize}">
                                <button class="btn btn-sm text-white bg-maroon qty-decrease">−</button>
                                <input type="text" class="form-control text-center cart-qty" value="${res.quantity}" readonly>
                                <button class="btn btn-sm text-white bg-maroon qty-increase">+</button>
                            </div>
                        </div>
                    `;
                    $button.replaceWith(qtyHtml);

                    showSuccessModal(res.message);
                } else if (res.status === 'unauthenticated') {
                    alert('Please log in to add to cart.');
                }
            },
            error: function () {
                alert('Something went wrong!');
            }
        });
    });
 </script>
@endsection
       