@extends('layouts/layout')

@section('content')
    <div class="container mt-5 mb-3">
        <!-- Left Side - Contact Form -->
        <div class="form-section">
            <h1 class="title">We're here to help</h1>
            
            <form id="contactForm" method="POST" action="{{ route('contact.submit') }}">
                    @csrf

                    <!-- Name Field -->
                    <div class="form-group">
                        <label class="form-label" for="name">Name</label>
                        <input type="text" id="name" name="name" class="form-input" placeholder="eg. john smith" required>
                    </div>

                    <!-- Email Field -->
                    <div class="form-group">
                        <label class="form-label" for="email">Email Address</label>
                        <input type="email" id="email" name="email" class="form-input" placeholder="eg. example@gmail.com" required>
                    </div>

                    <!-- Message Field -->
                    <div class="form-group">
                        <label class="form-label" for="message">Message</label>
                        <textarea id="message" name="message" class="form-input message-input" placeholder="Let us know how we can help" required></textarea>
                    </div>

                    <!-- Submit Button -->
                    <div class="d-flex justify-content-center">
                        <button type="submit" class="submit-btn">Send message</button>
                    </div>
                </form>

        </div>

        <!-- Right Side - Company Information -->
        <div class="info-section">
            <div class="info-header">
                <div class="logo"><img src="{{ asset('images/d6355990a69bcfe17bcd4d24ce5932c8cfd2c793.png') }}" alt="Logo" style="width: 90px; height: auto;"></div>
                <div class="company-name">{{$companyDetail->company_name}}</div>
            </div>

            <div class="address">
                {{$companyDetail->address}}
            </div>

            <div class="contact-info">
                <strong>Phone:</strong> {{$companyDetail->phone}}<br>
                <strong>Email:</strong> {{$companyDetail->email}}
            </div>
        </div>
    </div>



@endsection
    <style>
        body {
            font-family: 'Poltawski Nowy', serif !important;
            background-color: #f5f2ed;
        }
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            display: flex;
            gap: 60px;
            align-items: flex-start;
        }

        .form-section {
            flex: 1;
        }

        .title {
            font-size: 4rem;
            font-weight: normal;
            color: #333;
            margin-bottom: 30px;
            line-height: 1.1;
        }

        .form-group {
            margin-bottom: 30px;
        }

        .form-label {
            display: block;
            font-size: 1.5rem;
            color: #333;
            margin-bottom: 8px;
            font-weight: bold;
        }

        .form-input {
            width: 100%;
            padding: 20px 25px;
            border: none;
            border-radius: 8px;
            background: linear-gradient(to bottom, #FFF1DE, #FFE0B6);
            font-size: 1rem;
            color: #666;
            font-family: serif;
            outline: none;
        }

        .form-input::placeholder {
            color: #999;
            font-style: italic;
        }

        .message-input {
            min-height: 120px;
            resize: vertical;
        }

        .submit-btn {
            background-color: #652E2E;
            color: white;
            padding: 10px 30px;
            border: none;
            border-radius: 25px;
            font-size: 1.1rem;
            font-family: serif;
            cursor: pointer;
            /* margin-top: 20px; */
            transition: all 0.3s ease;
        }

        .submit-btn:hover {
            background-color: #5a3f35;
            transform: translateY(-2px);
        }

        .info-section {
            flex: 1;
             background: linear-gradient(to bottom, #FFF1DE, #FFE0B6);
            padding: 40px;
            border-radius: 15px;
            margin-top: 55px;
            position: relative;
             top: 64px;

        }

        .info-header {
            display: flex;
            align-items: center;
            margin-bottom: 30px;
        }

        .logo {
            width: 60px;
            height: 60px;
            background-color: #6b4e42;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 20px;
            color: #d4af37;
            font-size: 1.5rem;
            font-weight: bold;
        }

        .company-name {
            font-size: 1.8rem;
            color: #97682D;
            font-weight: normal;
        }

        .address {
            font-size: 1.1rem;
            color: #333;
            line-height: 1.6;
            margin-bottom: 30px;
        }

        .contact-info {
            font-size: 1.1rem;
            color: #333;
            line-height: 1.8;
        }

        .contact-info strong {
            font-weight: normal;
        }

        /* Enhanced Responsive Design */
        @media (max-width: 1024px) {
            .container {
                gap: 40px;
            }

            body {
                padding: 40px 20px;
            }

            .title {
                font-size: 3.5rem;
            }
        }

        @media (max-width: 768px) {
            .container {
                flex-direction: column;
                gap: 30px;
            }

            body {
                padding: 30px 15px;
            }

            .title {
                font-size: 2.8rem;
                margin-bottom: 40px;
                text-align: center;
            }

            .info-section {
                margin-top: 0;
                padding: 35px;
            }

            .form-input {
                padding: 18px 20px;
                font-size: 1rem;
            }

            .submit-btn {
                padding: 16px 40px;
                width: 100%;
                font-size: 1.1rem;
            }

            .form-label {
                font-size: 1.1rem;
            }

            .info-header {
                justify-content: center;
                text-align: center;
                flex-direction: column;
                gap: 15px;
            }

            .address, .contact-info {
                text-align: center;
            }
        }

        @media (max-width: 480px) {
            body {
                padding: 20px 10px;
            }

            .title {
                font-size: 2.2rem;
                margin-bottom: 30px;
            }

            .info-section {
                padding: 25px 20px;
            }

            .company-name {
                font-size: 1.4rem;
            }

            .logo {
                width: 50px;
                height: 50px;
                font-size: 1.2rem;
            }

            .form-input {
                padding: 15px 18px;
                font-size: 0.95rem;
            }

            .submit-btn {
                padding: 14px 30px;
                font-size: 1rem;
            }

            .form-label {
                font-size: 1rem;
            }

            .address {
                font-size: 1rem;
                line-height: 1.5;
            }

            .contact-info {
                font-size: 1rem;
            }

            .info-header {
                margin-bottom: 25px;
            }
        }

        @media (max-width: 360px) {
            .title {
                font-size: 1.8rem;
            }

            .form-input {
                padding: 12px 15px;
            }

            .submit-btn {
                padding: 12px 25px;
                font-size: 0.95rem;
            }

            .info-section {
                padding: 20px 15px;
            }

            .company-name {
                font-size: 1.2rem;
            }

            body {
                padding: 15px 8px;
            }
        }

        /* Landscape orientation for tablets */
        @media (max-width: 1024px) and (orientation: landscape) {
            .container {
                flex-direction: row;
                gap: 30px;
            }

            .title {
                font-size: 2.5rem;
            }

            body {
                padding: 20px;
            }
        }

        /* Extra large screens */
        @media (min-width: 1400px) {
            .container {
                max-width: 1400px;
                gap: 80px;
            }

            .title {
                font-size: 4.5rem;
            }

            .info-section {
                padding: 50px;
            }
        }
    </style>