@extends('layouts/layout')

@section('content')

<!-- Categories Section -->
    <div class="categories-section">
      <div class="container">
        <!-- Category Buttons -->
        <div class="d-flex flex-nowrap justify-content-center gap-5 mb-4 px-2 overflow-auto" style="white-space: nowrap;position: sticky; top: 85px; z-index: 1000; background-color:#FFF6EA; padding:15px;">
          @foreach ($categories as $category)
           @if (!in_array($category->id, [9, 10]))
              <button class="btn custom" data-category="{{ $category->title }}">{{ Str::limit($category->title, 14, '') }}</button>
            @endif
          @endforeach
          <button class="btn custom" data-category="all">See All</button>
        </div>

        <!-- Product Grid -->
        <div class="row g-4" id="productContainer">
            @foreach ($products as $product)
                <div class="col-md-4 product-item category-card" data-category="{{ $product->category->title ?? '' }}">
                  <div class="image-wrapper position-relative">
                    
                    <!-- Heart Icon Link (outside image link) -->
                    <a href="javascript:void(0);" 
                      class="heart-icon position-absolute wishlist-toggle text-brown" 
                      data-product-id="{{ $product->id }}"
                      style="top: 10px; right: 10px; z-index: 2;">
                      <i class="fa-{{ in_array($product->id, $wishlistIds) ? 'solid' : 'regular' }} fa-heart fs-4 text-brown"></i>
                    </a>

                    <!-- Image Link -->
                      @php
                          $productImages = $product->images->pluck('image_path')->toArray();
                          $mainImage = $productImages[0] ?? 'images/no-image.png';
                          $hoverImage = $productImages[1] ?? $mainImage; // fallback if only 1 image
                      @endphp
                    <a href="{{ route('product.detail', $product->id) }}" class="text-decoration-none d-block">
                      <img src="{{ asset('storage/' . $product->image) }}" class="main-img img-fluid" alt="Product">
                      <img src="{{ asset('storage/' . $hoverImage) }}" class="hover-img img-fluid position-absolute top-0 start-0">
                    </a>
                  </div>
                </div>

              @endforeach
            
          </div>
        </div>
    </div>
<script>
$(document).ready(function () {
  $('.wishlist-toggle').click(function () {
    let productId = $(this).data('product-id');
    let icon = $(this).find('i');

    $.ajax({
      url: "{{ route('wishlist.toggle') }}",
      type: "POST",
      data: {
        _token: '{{ csrf_token() }}',
        product_id: productId
      },
      success: function (res) {
        if (res.status === 'added') {
          icon.removeClass('fa-regular').addClass('fa-solid');
        } else if (res.status === 'removed') {
          icon.removeClass('fa-solid').addClass('fa-regular');
        }
      },
      error: function (xhr) {
        if (xhr.status === 401) {
          alert('Please log in to use the wishlist.');
        }
      }
    });
  });
});
</script>

@endsection
       