@extends('admin.admin-layout')

@section('content')

<!-- Start Container Fluid -->
<div class="container-xxl">


    <div class="row mt-4">
        <div class="col-xl-12">
            <div class="card">
                <div class="d-flex card-header justify-content-between align-items-center">
                    <div>
                        <h4 class="card-title mb-0">All User's List</h4>
                    </div>

                    <form class="d-flex align-items-center gap-2 mb-0" method="GET" action="{{ route('all.users') }}">
                        <div class="position-relative">
                            <input type="search" class="form-control pe-5" name="search" placeholder="Search by name, email"
                                value="{{ request('search') }}">
                            <iconify-icon id="searchIcon" icon="solar:magnifer-broken"
                                        class="search-widget-icon position-absolute top-50 end-0 translate-middle-y me-2"></iconify-icon>
                        </div>

                        @if(request('search'))
                            <a href="{{ route('all.users') }}" class="btn btn-sm btn-light">×</a>
                        @endif
                    </form>
                </div>

                <div>
                    <div class="table-responsive">
                        <table class="table align-middle mb-0 table-hover table-centered">
                            <thead class="bg-light-subtle">
                                <tr>
                                    <th>#</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Phone</th>
                                    <th>User Type</th>
                                    <th>Registered At</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($users as $index => $user)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>
                                            {{ $user->name }}
                                        </td>
                                        <td>{{ $user->email }}</td>
                                        <td>{{ $user->mobile ?? 'N/A' }}</td>
                                        <td>{{ $user->user_type == 1 ? 'Admin' : 'User' }}</td>
                                        <td>{{ $user->created_at->format('d M Y') }}</td>
                                        <td>
                                            <div class="d-flex gap-2">
                                                <!-- <a href="#" class="btn btn-soft-primary btn-sm">
                                                    <iconify-icon icon="solar:pen-2-broken" class="align-middle fs-18"></iconify-icon>
                                                </a> -->
                                                <form action="{{ route('destroy.user', $user->id) }}" method="POST" class="delete-order-form">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-soft-danger btn-sm sweetalert-delete-btn">
                                                        <iconify-icon icon="solar:trash-bin-minimalistic-2-broken" class="align-middle fs-18"></iconify-icon>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="5" class="text-center">No customers found.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer border-top">
                    {{ $users->links() }}
                </div>
            </div>
        </div>
    </div>

</div>
<!-- End Container Fluid -->

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const deleteButtons = document.querySelectorAll('.sweetalert-delete-btn');

    deleteButtons.forEach(button => {
        button.addEventListener('click', function (e) {
            e.preventDefault(); // Prevent immediate form submission
            const form = this.closest('form');

            Swal.fire({
                title: 'Are you sure?',
                text: "This user will be permanently deleted!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, delete user!',
                cancelButtonText: 'No, cancel!',
                customClass: {
                    confirmButton: 'btn btn-primary w-xs me-2 mt-2',
                    cancelButton: 'btn btn-danger w-xs mt-2'
                },
                buttonsStyling: false
            }).then((result) => {
                if (result.isConfirmed) {
                    form.submit(); // Submit the form if confirmed
                } else if (result.dismiss === Swal.DismissReason.cancel) {
                    Swal.fire({
                        title: 'Cancelled',
                        text: 'The user was not deleted.',
                        icon: 'info',
                        confirmButtonText: 'OK',
                        customClass: {
                            confirmButton: 'btn btn-primary mt-2'
                        },
                        buttonsStyling: false
                    });
                }
            });
        });
    });
});
</script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const input = document.getElementById('userSearchInput');
        const icon = document.getElementById('searchIcon');

        function toggleIcon() {
            if (input.value.trim().length > 0) {
                icon.style.display = 'none';
            } else {
                icon.style.display = '';
            }
        }

        input.addEventListener('input', toggleIcon);
        toggleIcon(); // Run on page load in case there's already a value
    });
</script>


@endsection
<style>
    input[type="search"]::-webkit-search-cancel-button {
    display: none;
}
</style>