@extends('admin.admin-layout')

@section('content')
<!-- Start Container Fluid -->
<div class="container-xxl">
     @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif
        <div class="card">
            <div class="card-header d-flex justify-content-end align-items-center  gap-1">
                <div class="d-flex gap-2">
                    <a href="{{route('All-coupons') }}" class="btn btn-sm btn-secondary">← Back</a>
                </div>
            </div>
        </div>
    <form action="{{ route('Store-coupon') }}" method="POST">
        @csrf
        <div class="row">
            <div class="col-lg-5">
                <!-- Coupon Status -->
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Coupon Status</h4>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="status" value="active" id="flexRadioDefault9" checked>
                                    <label class="form-check-label" for="flexRadioDefault9">Active</label>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="status" value="inactive" id="flexRadioDefault10">
                                    <label class="form-check-label" for="flexRadioDefault10">In Active</label>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="status" value="future" id="flexRadioDefault11">
                                    <label class="form-check-label" for="flexRadioDefault11">Future Plan</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Date Schedule -->
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Date Schedule</h4>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="start-date" class="form-label text-dark">Start Date</label>
                            <input type="date" id="start-date" name="start_date" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label for="end-date" class="form-label text-dark">End Date</label>
                            <input type="date" id="end-date" name="end_date" class="form-control" required>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Coupon Info -->
            <div class="col-lg-7">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Coupon Information</h4>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <!-- Coupon Code -->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="coupons-code" class="form-label">Coupons Code</label>
                                    <input type="text" id="coupons-code" name="code" class="form-control" placeholder="Code enter" required>
                                </div>
                            </div>
                            <!-- Coupon Limit -->
                            <div class="col-lg-6">
                            </div>
                        </div>

                        <!-- Coupon Type -->
                        <h4 class="card-title mb-3 mt-2">Coupons Types</h4>
                        <div class="row mb-3">
                            <div class="col-lg-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="type" id="flexRadioDefault12" value="free_shipping" checked>
                                    <label class="form-check-label" for="flexRadioDefault12">Free Shipping</label>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="type" id="flexRadioDefault13" value="percent">
                                    <label class="form-check-label" for="flexRadioDefault13">Percentage</label>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="type" id="flexRadioDefault14" value="fixed">
                                    <label class="form-check-label" for="flexRadioDefault14">Fixed Amount</label>
                                </div>
                            </div>
                        </div>

                        <!-- Discount Value -->
                        <div class="row">
                            <div class="col-lg-12">
                                <label for="discount-value" class="form-label">Discount Value</label>
                                <input type="text" id="discount-value" name="value" class="form-control" placeholder="value enter" required>
                            </div>
                        </div>
                    </div>

                    <!-- Submit -->
                    <div class="card-footer border-top">
                        <button type="submit" class="btn btn-primary">Create Coupon</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<!-- End Container Fluid -->
@endsection
