@extends('admin.admin-layout')

@section('content')
<!-- Start Container Fluid -->
<div class="container-xxl">
    <div class="row">
        <div class="col-xl-9 col-lg-8">
            <form action="{{ route('Category.Update', $category->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center gap-1">
                        <h4 class="card-title">Edit Category</h4>
                        <a href="{{ url()->previous() }}" class="btn btn-sm btn-primary">← Back</a>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="category-title" class="form-label">Category Title</label>
                                    <input type="text" id="category-title" name="category_title" class="form-control"
                                        placeholder="Enter Title" value="{{ old('category_title', $category->title) }}" required>
                                    @error('category_title')
                                        <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-lg-6">
                                <div class="mb-1">
                                    <label for="categoryimage" class="form-label">Category Image</label>
                                    <input type="file" name="categoryimage" id="categoryimage" class="form-control">
                                    @error('categoryimage')
                                        <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-xl-3 col-lg-4">
                                <div id="preview-container" class="bg-light text-center rounded" style="display: block;">
                                    <img id="preview-image" src="{{ asset('storage/' . $category->image) }}" alt="Preview Image" class="img-fluid rounded bg-light">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-lg-12">
                                <div class="mb-0">
                                    <label for="description" class="form-label">Description</label>
                                    <textarea class="form-control bg-light-subtle" id="description" name="description"
                                        rows="7" placeholder="Type description" required>{{ old('description', $category->description) }}</textarea>
                                    @error('description')
                                        <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="p-3 bg-light mb-3 rounded">
                    <div class="row justify-content-end g-2">
                        <div class="col-lg-3">
                            <button type="submit" class="btn btn-outline-secondary w-100">Update Category</button>
                        </div>
                        <div class="col-lg-2">
                            <a href="{{ route('Category.list') }}" class="btn btn-primary w-100">Cancel</a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- End Container Fluid -->

{{-- JS Preview Script --}}
<script>
    document.getElementById('categoryimage').addEventListener('change', function (event) {
        const [file] = event.target.files;
        const previewContainer = document.getElementById('preview-container');
        if (file) {
            document.getElementById('preview-image').src = URL.createObjectURL(file);
            previewContainer.style.display = 'block';
        } else {
            previewContainer.style.display = 'none';
        }
    });
</script>
@endsection
