@extends('admin.admin-layout')

@section('content')
<!-- Start Container Fluid -->
<div class="container-xxl">
    <div class="row">
        @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show w-50" role="alert">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        @if (session('error'))
            <div class="alert alert-danger alert-dismissible fade show w-50" role="alert">
                {{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        <div class="col-xl-9 col-lg-8">
            <form action="{{ route('about.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center gap-1">
                        <h4 class="card-title">About-Us Information</h4>
                        <a href="{{route('admin.dashboard') }}" class="btn btn-sm btn-secondary">← Back</a>
                    </div>
                    <div class="card-body">
                        <!-- Content -->
                        <div class="mb-3">
                            <label for="content" class="form-label">Content</label>
                            <textarea name="content" id="description" class="form-control" rows="5">{{ $about->content ?? '' }}</textarea>
                        </div>
                        <!-- Banner Image -->
                        <div class="mb-3">
                            <label for="banner_image" class="form-label">Banner Image</label>
                            <input type="file" class="form-control" name="banner_image" id="banner_image" accept="image/*">

                            <div class="mt-2">
                                <img id="preview_banner"
                                    class="img-fluid rounded mt-2"
                                    src="{{ !empty($about) && $about->banner_image ? asset('storage/' . $about->banner_image) : asset('assets/images/placeholder.jpg') }}"
                                    >
                            </div>
                        </div>

                        <!-- Banner Image -->
                        <div class="mb-3">
                            <label for="banner_image2" class="form-label">Banner Image 2</label>
                            <input type="file" class="form-control" name="banner_image2" id="banner_image2" accept="image/*">

                            <div class="mt-2">
                                <img id="preview_banner_image2"
                                    class="img-fluid rounded mt-2"
                                    src="{{ !empty($about) && $about->banner_image2 ? asset('storage/' . $about->banner_image2) : asset('assets/images/placeholder.jpg') }}"
                                    >
                            </div>
                        </div>

                        <!-- Banner Image -->
                        <div class="mb-3">
                            <label for="banner_image3" class="form-label">Banner Image 3</label>
                            <input type="file" class="form-control" name="banner_image3" id="banner_image3" accept="image/*">

                            <div class="mt-2">
                                <img id="preview_banner_image3"
                                    class="img-fluid rounded mt-2"
                                    src="{{ !empty($about) && $about->banner_image3 ? asset('storage/' . $about->banner_image3) : asset('assets/images/placeholder.jpg') }}"
                                    >
                            </div>
                        </div>



                        <!-- Banner Text -->
                        <div class="mb-3">
                            <label for="banner_text" class="form-label">Banner Text</label>
                            <input type="text" name="banner_text" class="form-control" value="{{ $about->banner_text ?? '' }}">
                        </div>

                        <!-- About Image -->
                        <div class="mb-3">
                            <label for="about_image" class="form-label">About Image</label>
                            <input type="file" class="form-control" name="about_image" id="about_image" accept="image/*">

                            <div class="mt-2">
                                <img id="preview_about"
                                    class="img-fluid rounded mt-2"
                                    src="{{ !empty($about) && $about->about_image ? asset('storage/' . $about->about_image) : asset('assets/images/placeholder.jpg') }}"
                                    >
                            </div>
                        </div>
                    </div>
                </div>


                <!-- Submit -->
                  <div class="p-3 bg-light mb-3 rounded">
                    <div class="row justify-content-end g-2">
                        <div class="col-lg-2">
                            <button type="submit" class="btn btn-outline-secondary w-100">Save</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Preview Image Script -->
<script>
    document.getElementById('banner_image').addEventListener('change', function(event) {
        const preview = document.getElementById('preview_banner');
        const file = event.target.files[0];
        preview.src = file ? URL.createObjectURL(file) : "{{ asset('assets/images/placeholder.jpg') }}";
    });

    document.getElementById('banner_image2').addEventListener('change', function(event) {
        const preview = document.getElementById('preview_banner_image2');
        const file = event.target.files[0];
        preview.src = file ? URL.createObjectURL(file) : "{{ asset('assets/images/placeholder.jpg') }}";
    });

    document.getElementById('banner_image3').addEventListener('change', function(event) {
        const preview = document.getElementById('preview_banner_image3');
        const file = event.target.files[0];
        preview.src = file ? URL.createObjectURL(file) : "{{ asset('assets/images/placeholder.jpg') }}";
    });

    document.getElementById('about_image').addEventListener('change', function(event) {
        const preview = document.getElementById('preview_about');
        const file = event.target.files[0];
        preview.src = file ? URL.createObjectURL(file) : "{{ asset('assets/images/placeholder.jpg') }}";
    });
</script>
@endsection
