@extends('admin.admin-layout')

@section('content')
<!-- Start Container Fluid -->
<div class="container-xxl">
    <div class="row">
        @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show w-50" role="alert">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        @if (session('error'))
            <div class="alert alert-danger alert-dismissible fade show w-50" role="alert">
                {{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        <div class="col-xl-9 col-lg-8">
            <form action="{{ $formAction }}" method="POST">
                @csrf
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center gap-1">
                        <h4 class="card-title">Frequently Asked Question's</h4>
                        <a href="{{route('FAQs.index') }}" class="btn btn-sm btn-secondary">← Back</a>
                    </div>
                    <div class="card-body">
                        <!-- Content -->
                        <div class="mb-3">
                            <label for="question" class="form-label">Question</label>
                            <input type="text" name="question" id="question" class="form-control" value="{{ $faq->question ?? '' }}" required>
                        </div>

                        <div class="mb-3">
                            <label for="answer" class="form-label">Answer</label>
                            <textarea name="answer" id="answer" class="form-control" rows="8" required>{{ $faq->answer ?? '' }}</textarea>
                        </div>

                        <div class="mb-3">
                            <label for="category_id" class="form-label">Category</label>
                            <select name="category_id" class="form-control" required>
                                <option value="">Select Category</option>
                                @foreach($faqCategories as $category)
                                    <option value="{{ $category->id }}"
                                        {{ (old('category_id', $faq->category_id ?? '') == $category->id) ? 'selected' : '' }}>
                                        {{ $category->name }}
                                    </option>
                                @endforeach
                            </select>

                        </div>

                    </div>
                </div>

                <!-- Submit -->
                <div class="p-3 bg-light mb-3 rounded">
                    <div class="row justify-content-end g-2">
                        <div class="col-lg-2">
                            <button type="submit" class="btn btn-outline-secondary w-100">Save</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
