@extends('layouts/layout')

@section('content')
   <!-- Hero Section Carousel -->
<div id="heroCarousel" class="carousel slide carousel-fade" data-bs-ride="carousel" data-bs-interval="1000">
  <!-- Indicators (dots)
  <div class="carousel-indicators">
    <button type="button" data-bs-target="#heroCarousel" data-bs-slide-to="0" class="active" aria-current="true" aria-label="Slide 1"></button>
    <button type="button" data-bs-target="#heroCarousel" data-bs-slide-to="1" aria-label="Slide 2"></button>
    <button type="button" data-bs-target="#heroCarousel" data-bs-slide-to="2" aria-label="Slide 3"></button>
  </div> -->

  <div class="carousel-inner">

    <!-- Slide 1 -->
    <div class="carousel-item active">
      <div class="hero-section d-block mb-1" style="background-image: url('{{ $about && $about->banner_image ? asset('storage/' . $about->banner_image) : asset('images/hero2.jpg') }}');">
        <div class="container">
          <div class="row">
            <div class="col-md-6">
              <h1 class="banner-text">{{ $about->banner_text ?? ''}}</h1>
            </div>
          </div>
          <div class="d-flex flex-nowrap justify-content-start gap-5  px-2 overflow-auto" style="white-space: nowrap; margin-top: 11%;">
            @foreach ($categories as $category)
              @if (!in_array($category->id, [9, 10]))
                  <a href="{{ route('New-Arrival-Id', $category->id) }}" class="btn custom" data-category="{{ $category->title }}">{{ Str::limit($category->title, 14, '') }}</a>
                @endif
            @endforeach
            <a href="{{ route('New-Arrival') }}" class="btn custom" data-category="all">See All</a>
        </div>

        </div>
      </div>
    </div>

    <!-- Slide 2 -->
    <div class="carousel-item">
      <div class="hero-section d-block " style="background-image: url('{{ $about && $about->banner_image2 ? asset('storage/' . $about->banner_image2) : asset('images/hero2.jpg') }}');">
        <div class="container">
          <div class="row">
            <div class="col-md-6">
              <h1 class="banner-text">{{ $about->banner_text ?? ''}}</h1>
            </div>
          </div>
         <div class="d-flex flex-nowrap justify-content-start gap-5  px-2 overflow-auto" style="white-space: nowrap;margin-top: 11%;">
            @foreach ($categories as $category)
              @if (!in_array($category->id, [9, 10]))
                  <a href="{{ route('New-Arrival-Id', $category->id) }}" class="btn custom" data-category="{{ $category->title }}">{{ Str::limit($category->title, 14, '') }}</a>
                @endif
            @endforeach
            <a href="{{ route('New-Arrival') }}" class="btn custom" data-category="all">See All</a>
          </div>

        </div>
      </div>
    </div>

    <!-- Slide 3 -->
    <div class="carousel-item">
      <div class="hero-section d-block " style="background-image: url('{{ $about && $about->banner_image3 ? asset('storage/' . $about->banner_image3) : asset('images/hero2.jpg') }}');">
        <div class="container">
          <div class="row">
            <div class="col-md-6">
              <h1 class="banner-text">{{ $about->banner_text ?? ''}}</h1>
            </div>
          </div>
         <div class="d-flex flex-nowrap justify-content-start gap-5  px-2 overflow-auto" style="white-space: nowrap;margin-top: 11%;">
            @foreach ($categories as $category)
              @if (!in_array($category->id, [9, 10]))
                  <a href="{{ route('New-Arrival-Id', $category->id) }}" class="btn custom" data-category="{{ $category->title }}">{{ Str::limit($category->title, 14, '') }}</a>
                @endif
            @endforeach
            <a href="{{ route('New-Arrival') }}" class="btn custom" data-category="all">See All</a>
          </div>

        </div>
      </div>
    </div>

  </div>
</div>


     <section class="about-section" style="background-color: #FFF6EA;">
    <h1 class="about-title">About Us</h1>
    <div class="subheading">
      <span>Welcome to</span>
      <img src="images/d6355990a69bcfe17bcd4d24ce5932c8cfd2c793.png" alt="C3 Logo" class="logo-badge">
      <span>Where Elegance Meets Expression</span>
    </div>
    <div class="about-content">
      <img src="{{ asset('storage/' . $about->about_image) }}" alt="Fashion Image" class="about-image">
      <div class="about-text">
        <p>{!! $about->content ?? '' !!}</p>

      </div>
    </div>
  </section>

@endsection
