@extends('admin.admin-layout')

@section('content')

<!-- Start Container Fluid -->
<div class="container-xxl">
    <form action="{{ route('admin.users.update', $user->id) }}" method="POST">
        @csrf
 

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Edit User Details</h4>
                    </div>
                    <div class="card-body">
                        <div class="row">

                            <!-- Full Name -->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="name" class="form-label">Full Name</label>
                                    <input type="text" id="name" name="name" class="form-control" value="{{ old('name', $user->name) }}">
                                    @error('name')
                                        <small class="text-danger">{{ $message }}</small>
                                    @enderror
                                </div>
                            </div>

                            <!-- Email (Read-only) -->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="email" class="form-label">Email </label>
                                    <input type="email" id="email" name="email" class="form-control" value="{{ $user->email }}" readonly>
                                </div>
                            </div>

                            <!-- Alternate Name -->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="alt_name" class="form-label">Alternate Name</label>
                                    <input type="text" id="alt_name" name="alt_name" class="form-control" value="{{ old('alt_name', $user->alt_name) }}">
                                </div>
                            </div>

                            <!-- Mobile -->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="mobile" class="form-label">Mobile</label>
                                    <input type="text" id="mobile" name="mobile" class="form-control" value="{{ old('mobile', $user->mobile) }}">
                                </div>
                            </div>

                            <!-- Alt Mobile -->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="alt_mobile" class="form-label">Alternate Mobile</label>
                                    <input type="text" id="alt_mobile" name="alt_mobile" class="form-control" value="{{ old('alt_mobile', $user->alt_mobile) }}">
                                </div>
                            </div>

                            <!-- DOB -->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="dob" class="form-label">Date of Birth</label>
                                    <input type="date" id="dob" name="dob" class="form-control" value="{{ old('dob', $user->dob) }}">
                                </div>
                            </div>

                            <!-- User Type -->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="user_type" class="form-label">User Type</label>
                                    <select name="user_type" id="user_type" class="form-control">
                                        <option value="1" {{ $user->user_type == 1 ? 'selected' : '' }}>Admin</option>
                                        <option value="0" {{ $user->user_type == 0 ? 'selected' : '' }}>User</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Created At (read only) -->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="created_at" class="form-label">Created At</label>
                                    <input type="text" class="form-control" value="{{ $user->created_at->format('d M Y, h:i A') }}" readonly>
                                </div>
                            </div>

                            <!-- Reset Password -->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="password" class="form-label">Reset Password</label>
                                    <input type="password" id="password" name="password" class="form-control" placeholder="Enter new password">
                                    @error('password')
                                        <small class="text-danger">{{ $message }}</small>
                                    @enderror
                                </div>
                            </div>

                            <!-- Confirm Password -->
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="password_confirmation" class="form-label">Confirm Password</label>
                                    <input type="password" id="password_confirmation" name="password_confirmation" class="form-control" placeholder="Confirm new password">
                                </div>
                            </div>

                        </div> <!-- row -->
                    </div> <!-- card-body -->

                    <div class="card-footer border-top d-flex justify-content-between">
                        <a href="{{ route('admin.dashboard') }}" class="btn btn-secondary">Back</a>
                        <button type="submit" class="btn btn-primary">Update User</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<!-- End Container Fluid -->
@if (session('success'))
    <script>
        Swal.fire({
            icon: 'success',
            title: 'Success!',
            text: "{{ session('success') }}",
            confirmButtonText: 'OK',
            customClass: {
                confirmButton: 'btn btn-primary'
            },
            buttonsStyling: false
        });
    </script>
@endif

@endsection
