@extends('admin.admin-layout')

@section('content')

               <!-- Start Container Fluid -->
               <div class="container-xxl">

                    <div class="row">
                          @if(session('success'))
                              <div class="alert alert-success" role="alert">
                                   {{ session('success') }}
                              </div>
                         @endif
                         
                         <div class="col-xl-12">
                              <div class="card">
                                   <div class="card-header d-flex justify-content-between align-items-center gap-1">
                                        <h4 class="card-title flex-grow-1">All Categories </h4>

                                        <a href="{{route('Category.Add')}}" class="btn btn-sm btn-primary">
                                             Add Category
                                        </a>
                                   </div>
                                   <div>
                                        <div class="table-responsive">
                                             <table class="table align-middle mb-0 table-hover table-centered">
                                                  <thead class="bg-light-subtle">
                                                       <tr>
                                                            <th></th>
                                                            <th>Categories</th>
                                                            <th>Thumbnail</th>
                                                            <th>Action</th>
                                                       </tr>
                                                  </thead>
                                                  <tbody>
                                                        @forelse($categories as $index => $category)
                                                       <tr>
                                                            <td></td>
                                                            <td>
                                                                 <div class="d-flex align-items-center gap-2">
                                                                      <div class="rounded bg-light avatar-md d-flex align-items-center justify-content-center">
                                                                           <img src="{{ asset('storage/'.$category->image) }}" alt="" class="avatar-md">
                                                                      </div>
                                                                 </div>

                                                            </td>
                                                            <td>
                                                                 <a href="{{ route('Category.Edit.id', $category->id ) }}" class="link-primary fw-medium">
                                                                      <p class=" fw-medium fs-15 mb-0">{{ $category->title }}</p>
                                                                 </a>
                                                            </td>
                                                            <td>
                                                                 <div class="d-flex gap-2">
                                                                      <a href="{{ route('Category.Edit.id', $category->id ) }}" class="btn btn-soft-primary btn-sm"><iconify-icon icon="solar:pen-2-broken" class="align-middle fs-18"></iconify-icon></a>
                                                                      <form action="{{ route('categories.destroy', $category->id) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this category?');">
                                                                           @csrf
                                                                           @method('DELETE')
                                                                           <button type="submit" class="btn btn-soft-danger btn-sm"><iconify-icon icon="solar:trash-bin-minimalistic-2-broken" class="align-middle fs-18"></iconify-icon></button>
                                                                      </form>
                                                                 </div>
                                                            </td>
                                                       </tr>
                                                        @empty
                                                            <tr>
                                                                 <td colspan="6" class="text-center text-muted">No categories found.</td>
                                                            </tr>
                                                       @endforelse
                                                  </tbody>
                                             </table>
                                        </div>
                                        <!-- end table-responsive -->
                                   </div>
                                   <div class="card-footer border-top">
                                        <nav aria-label="Page navigation example">
                                             <ul class="pagination justify-content-end mb-0">
                                                  {!! $categories->links('pagination::bootstrap-5') !!}
                                             </ul>
                                        </nav>
                                   </div>
                              </div>
                         </div>
                    </div>

               </div>
               <!-- End Container Fluid -->

@endsection
       